/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.scanners;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import springfox.documentation.schema.CollectionSpecification;
import springfox.documentation.schema.CompoundModelSpecification;
import springfox.documentation.schema.MapSpecification;
import springfox.documentation.schema.ModelKey;
import springfox.documentation.schema.ModelSpecification;
import springfox.documentation.schema.PropertySpecification;
import springfox.documentation.schema.QualifiedModelName;
import springfox.documentation.schema.ReferenceModelSpecification;
import springfox.documentation.spi.service.contexts.ModelSpecificationRegistry;

public class ModelSpecificationRegistryBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelSpecificationRegistryBuilder.class);
    private final MultiValueMap<QualifiedModelName, ModelSpecification> modelByQName = new LinkedMultiValueMap();
    private final Map<ModelKey, ModelSpecification> modelByKey = new HashMap<ModelKey, ModelSpecification>();

    public void add(ModelSpecification modelSpecification) {
        modelSpecification.key().ifPresent(key -> {
            if (!this.modelByKey.containsKey(key)) {
                List specsWithSameName;
                this.modelByKey.put((ModelKey)key, modelSpecification);
                if (!this.modelByQName.containsKey((Object)key.getQualifiedModelName())) {
                    this.modelByQName.add((Object)key.getQualifiedModelName(), (Object)modelSpecification);
                }
                if (!(specsWithSameName = (List)this.modelByQName.get((Object)key.getQualifiedModelName())).contains(modelSpecification)) {
                    this.modelByQName.add((Object)key.getQualifiedModelName(), (Object)modelSpecification);
                }
            }
        });
    }

    public void addAll(Collection<ModelSpecification> modelSpecifications) {
        modelSpecifications.forEach(this::add);
    }

    public ModelSpecificationRegistry build() {
        LinkedMultiValueMap referenceKeyToEffectiveKey = new LinkedMultiValueMap();
        HashMap<List<ModelKey>, Boolean> seen = new HashMap<List<ModelKey>, Boolean>();
        for (Map.Entry eachEntry : this.modelByQName.entrySet()) {
            List models = (List)eachEntry.getValue();
            if (models.size() <= 1) continue;
            LOGGER.trace("Starting comparison of model with name {}. Models to compare {}", eachEntry.getKey(), (Object)models.size());
            for (int i = 0; i < models.size() - 1; ++i) {
                for (int j = 1; j < models.size(); ++j) {
                    if (((ModelSpecification)models.get(i)).key().isPresent() && ((ModelSpecification)models.get(j)).key().isPresent()) {
                        ModelKey first = (ModelKey)((ModelSpecification)models.get(j)).key().get();
                        ModelKey second = (ModelKey)((ModelSpecification)models.get(i)).key().get();
                        seen.putIfAbsent(Arrays.asList(second, first), true);
                        if (this.sameModel((ModelSpecification)models.get(i), (ModelSpecification)models.get(j), (MultiValueMap<ModelKey, ModelKey>)referenceKeyToEffectiveKey, seen)) {
                            LOGGER.trace("Models were equivalent {} and {}", (Object)second, (Object)first);
                            referenceKeyToEffectiveKey.add((Object)second, (Object)first);
                            referenceKeyToEffectiveKey.add((Object)first, (Object)second);
                            continue;
                        }
                        LOGGER.trace("Models were different {} and {}", (Object)second, (Object)first);
                        continue;
                    }
                    LOGGER.trace("Models were different {} and {}", ((ModelSpecification)models.get(i)).key().orElse(null), ((ModelSpecification)models.get(j)).key().orElse(null));
                }
            }
            LOGGER.trace("Done comparison of models with name {}", eachEntry.getKey());
        }
        return new DefaultModelSpecificationRegistry(this.modelByKey, (MultiValueMap<ModelKey, ModelKey>)referenceKeyToEffectiveKey);
    }

    private boolean sameModel(ModelSpecification first, ModelSpecification second, MultiValueMap<ModelKey, ModelKey> referenceKeyToEffectiveKey, HashMap<List<ModelKey>, Boolean> seen) {
        if (Objects.equals(first, second)) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        return Objects.equals(first.getScalar(), second.getScalar()) && this.sameCompoundModel(first.getCompound().orElse(null), second.getCompound().orElse(null), referenceKeyToEffectiveKey, seen) && this.sameCollectionModel(first.getCollection().orElse(null), second.getCollection().orElse(null), referenceKeyToEffectiveKey, seen) && this.sameMapModel(first.getMap().orElse(null), second.getMap().orElse(null), referenceKeyToEffectiveKey, seen) && Objects.equals(first.getFacets(), second.getFacets()) && Objects.equals(first.getName(), second.getName()) && this.equivalentReference(first.getReference().map(ReferenceModelSpecification::getKey).orElse(null), second.getReference().map(ReferenceModelSpecification::getKey).orElse(null), referenceKeyToEffectiveKey, seen);
    }

    private boolean sameCollectionModel(CollectionSpecification first, CollectionSpecification second, MultiValueMap<ModelKey, ModelKey> referenceKeyToEffectiveKey, HashMap<List<ModelKey>, Boolean> seen) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        LOGGER.trace("Comparing collections {} and {}", (Object)first, (Object)first);
        return this.sameModel(first.getModel(), second.getModel(), referenceKeyToEffectiveKey, seen);
    }

    private boolean sameMapModel(MapSpecification first, MapSpecification second, MultiValueMap<ModelKey, ModelKey> referenceKeyToEffectiveKey, HashMap<List<ModelKey>, Boolean> seen) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        LOGGER.trace("Comparing Map  {} and {}", (Object)first, (Object)second);
        return this.sameModel(first.getKey(), second.getKey(), referenceKeyToEffectiveKey, seen) && this.sameModel(first.getValue(), second.getValue(), referenceKeyToEffectiveKey, seen);
    }

    private boolean sameCompoundModel(CompoundModelSpecification first, CompoundModelSpecification second, MultiValueMap<ModelKey, ModelKey> referenceKeyToEffectiveKey, HashMap<List<ModelKey>, Boolean> seen) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        LOGGER.trace("Comparing compound specs {} and {}", (Object)first, (Object)second);
        seen.put(Arrays.asList(first.getModelKey(), second.getModelKey()), true);
        boolean sameProperties = this.sameProperties(first.getProperties(), second.getProperties(), referenceKeyToEffectiveKey, seen);
        seen.put(Arrays.asList(first.getModelKey(), second.getModelKey()), sameProperties);
        return sameProperties && Objects.equals(first.getMaxProperties(), second.getMaxProperties()) && Objects.equals(first.getMinProperties(), second.getMinProperties()) && Objects.equals(first.getDiscriminator(), second.getDiscriminator());
    }

    private boolean sameProperties(Collection<PropertySpecification> first, Collection<PropertySpecification> second, MultiValueMap<ModelKey, ModelKey> referenceKeyToEffectiveKey, HashMap<List<ModelKey>, Boolean> seen) {
        if (first.size() != second.size()) {
            return false;
        }
        Map firstMap = first.stream().collect(Collectors.toMap(PropertySpecification::getName, Function.identity()));
        Map secondMap = second.stream().collect(Collectors.toMap(PropertySpecification::getName, Function.identity()));
        if (!firstMap.keySet().equals(secondMap.keySet())) {
            return false;
        }
        for (String name : firstMap.keySet()) {
            PropertySpecification secondProperty;
            PropertySpecification firstProperty = (PropertySpecification)firstMap.get(name);
            if (!this.sameProperty(firstProperty, secondProperty = (PropertySpecification)secondMap.get(name), referenceKeyToEffectiveKey, seen)) {
                LOGGER.trace("Properties {} did not match", (Object)firstProperty.getName());
                return false;
            }
            LOGGER.trace("Properties  {} matched", (Object)firstProperty.getName());
        }
        return true;
    }

    private boolean sameProperty(PropertySpecification first, PropertySpecification second, MultiValueMap<ModelKey, ModelKey> referenceKeyToEffectiveKey, HashMap<List<ModelKey>, Boolean> seen) {
        LOGGER.trace("Comparing property {}", (Object)first.getName());
        return first.getPosition() == second.getPosition() && Objects.equals(first.getName(), second.getName()) && Objects.equals(first.getDescription(), second.getDescription()) && this.sameModel(first.getType(), second.getType(), referenceKeyToEffectiveKey, seen) && Objects.equals(first.getFacets(), second.getFacets()) && Objects.equals(first.getNullable(), second.getNullable()) && Objects.equals(first.getRequired(), second.getRequired()) && Objects.equals(first.getReadOnly(), second.getReadOnly()) && Objects.equals(first.getWriteOnly(), second.getWriteOnly()) && Objects.equals(first.getDeprecated(), second.getDeprecated()) && Objects.equals(first.getAllowEmptyValue(), second.getAllowEmptyValue()) && Objects.equals(first.getHidden(), second.getHidden()) && Objects.equals(first.getExample(), second.getExample()) && Objects.equals(first.getDefaultValue(), second.getDefaultValue()) && Objects.equals(first.getXml(), second.getXml()) && Objects.equals(first.getVendorExtensions(), second.getVendorExtensions());
    }

    private boolean equivalentReference(ModelKey first, ModelKey second, MultiValueMap<ModelKey, ModelKey> referenceKeyToEffectiveKey, HashMap<List<ModelKey>, Boolean> seen) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (seen.containsKey(Arrays.asList(first, second))) {
            return seen.get(Arrays.asList(first, second));
        }
        LOGGER.trace("Comparing references {} and {}", (Object)first, (Object)second);
        seen.put(Arrays.asList(first, second), true);
        boolean isSame = this.sameModel(this.modelByKey.get(first), this.modelByKey.get(second), referenceKeyToEffectiveKey, seen);
        seen.put(Arrays.asList(first, second), isSame);
        if (isSame) {
            if (!referenceKeyToEffectiveKey.containsKey((Object)first)) {
                referenceKeyToEffectiveKey.add((Object)first, (Object)second);
            }
            if (!referenceKeyToEffectiveKey.containsKey((Object)second)) {
                referenceKeyToEffectiveKey.add((Object)second, (Object)first);
            }
        }
        return isSame;
    }

    private static class DefaultModelSpecificationRegistry
    implements ModelSpecificationRegistry {
        private final Map<ModelKey, ModelSpecification> modelsLookupByKey;
        private final MultiValueMap<ModelKey, ModelKey> referenceKeyToEffectiveKeys;

        DefaultModelSpecificationRegistry(Map<ModelKey, ModelSpecification> modelsLookupByKey, MultiValueMap<ModelKey, ModelKey> referenceKeyToEffectiveKeys) {
            this.referenceKeyToEffectiveKeys = referenceKeyToEffectiveKeys;
            this.modelsLookupByKey = modelsLookupByKey;
        }

        public ModelSpecification modelSpecificationFor(ModelKey key) {
            return this.modelsLookupByKey.get(key);
        }

        public boolean hasRequestResponsePairs(ModelKey test) {
            ModelKey other = test.flippedResponse();
            return this.modelsLookupByKey.containsKey(other) && !this.areEquivalent(test, other) && !this.areEquivalent(other, test);
        }

        private boolean areEquivalent(ModelKey first, ModelKey second) {
            return this.referenceKeyToEffectiveKeys.containsKey((Object)first) && ((List)this.referenceKeyToEffectiveKeys.get((Object)first)).contains(second);
        }

        public Collection<ModelKey> modelsDifferingOnlyInValidationGroups(ModelKey test) {
            return this.modelsLookupByKey.keySet().stream().filter(mk -> mk.getQualifiedModelName().equals((Object)test.getQualifiedModelName()) && Objects.equals(mk.getViewDiscriminator(), test.getViewDiscriminator()) && mk.isResponse() == test.isResponse() && !this.areEquivalent((ModelKey)mk, test)).collect(Collectors.toSet());
        }

        public Collection<ModelKey> modelsWithSameNameAndDifferentNamespace(ModelKey test) {
            return this.modelsLookupByKey.keySet().stream().filter(mk -> mk.getQualifiedModelName().getName().equals(test.getQualifiedModelName().getName()) && !mk.getQualifiedModelName().getNamespace().equals(test.getQualifiedModelName().getNamespace())).collect(Collectors.toSet());
        }

        public Set<ModelKey> modelKeys() {
            return this.modelsLookupByKey.keySet();
        }
    }
}

