/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.servlet;

import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.template.TemplateAvailabilityProviders;
import org.springframework.boot.autoconfigure.web.servlet.WelcomePage;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.log.LogMessage;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.handler.AbstractUrlHandlerMapping;
import org.springframework.web.servlet.mvc.ParameterizableViewController;

final class WelcomePageHandlerMapping
extends AbstractUrlHandlerMapping {
    private static final Log logger = LogFactory.getLog(WelcomePageHandlerMapping.class);
    private static final List<MediaType> MEDIA_TYPES_ALL = Collections.singletonList(MediaType.ALL);

    WelcomePageHandlerMapping(TemplateAvailabilityProviders templateAvailabilityProviders, ApplicationContext applicationContext, Resource indexHtmlResource, String staticPathPattern) {
        this.setOrder(2);
        WelcomePage welcomePage = WelcomePage.resolve(templateAvailabilityProviders, applicationContext, indexHtmlResource, staticPathPattern);
        if (welcomePage != WelcomePage.UNRESOLVED) {
            logger.info((Object)LogMessage.of(() -> !welcomePage.isTemplated() ? "Adding welcome page: " + indexHtmlResource : "Adding welcome page template: index"));
            ParameterizableViewController controller = new ParameterizableViewController();
            controller.setViewName(welcomePage.getViewName());
            this.setRootHandler(controller);
        }
    }

    public Object getHandlerInternal(HttpServletRequest request) throws Exception {
        return !this.isHtmlTextAccepted(request) ? null : super.getHandlerInternal(request);
    }

    private boolean isHtmlTextAccepted(HttpServletRequest request) {
        for (MediaType mediaType : this.getAcceptedMediaTypes(request)) {
            if (!mediaType.includes(MediaType.TEXT_HTML)) continue;
            return true;
        }
        return false;
    }

    private List<MediaType> getAcceptedMediaTypes(HttpServletRequest request) {
        String acceptHeader = request.getHeader("Accept");
        if (StringUtils.hasText((String)acceptHeader)) {
            try {
                return MediaType.parseMediaTypes((String)acceptHeader);
            }
            catch (InvalidMediaTypeException ex) {
                logger.warn((Object)"Received invalid Accept header. Assuming all media types are accepted", (Throwable)(logger.isDebugEnabled() ? ex : null));
            }
        }
        return MEDIA_TYPES_ALL;
    }
}

