/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.util;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.rest.util.SparkUIUtil;
import org.apache.spark.deploy.history.HistoryServer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component(value="SparkHistoryUIUtil")
@ConditionalOnProperty(name={"kylin.history-server.enable"}, havingValue="true")
public class SparkHistoryUIUtil {
    @Autowired
    @Qualifier(value="historyServer")
    private HistoryServer historyServer;
    public static final String HISTORY_UI_BASE = "/history_server";
    public static final String KYLIN_HISTORY_UI_BASE = "/kylin/history_server";
    public static final String PROXY_LOCATION_BASE = KylinConfig.getInstanceFromEnv().getUIProxyLocation() + "/history_server";

    public void proxy(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        String historyServerUrl = this.getHistoryServerUrl();
        String uriPath = servletRequest.getRequestURI().substring(KYLIN_HISTORY_UI_BASE.length());
        SparkUIUtil.resendSparkUIRequest((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, (String)historyServerUrl, (String)uriPath, (String)PROXY_LOCATION_BASE);
    }

    private String getHistoryServerUrl() {
        return String.format(Locale.ROOT, "http://%s:%s", InetAddress.getLocalHost().getHostAddress(), this.historyServer.boundPort());
    }

    public static String getHistoryTrackerUrl(String appId) {
        return PROXY_LOCATION_BASE + "/history/" + appId;
    }
}

