/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import io.swagger.annotations.ApiOperation;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.kylin.common.response.RestResponse;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataSegDetails;
import org.apache.kylin.metadata.cube.utils.StreamingUtils;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.streaming.StreamingJobRecord;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.request.StreamingJobExecuteRequest;
import org.apache.kylin.rest.request.StreamingJobFilter;
import org.apache.kylin.rest.request.StreamingJobParamsRequest;
import org.apache.kylin.rest.response.DataResult;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.StreamingJobDataStatsResponse;
import org.apache.kylin.rest.response.StreamingJobResponse;
import org.apache.kylin.rest.service.StreamingJobService;
import org.apache.kylin.streaming.metadata.StreamingJobMeta;
import org.apache.kylin.streaming.request.LayoutUpdateRequest;
import org.apache.kylin.streaming.request.StreamingJobStatsRequest;
import org.apache.kylin.streaming.request.StreamingJobUpdateRequest;
import org.apache.kylin.streaming.request.StreamingRequestHeader;
import org.apache.kylin.streaming.request.StreamingSegmentRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/streaming_jobs"}, produces={"application/vnd.apache.kylin-v4+json"})
public class StreamingJobController
extends NBasicController {
    @Autowired
    @Qualifier(value="streamingJobService")
    private StreamingJobService streamingJobService;

    @GetMapping(value={""})
    @ResponseBody
    public EnvelopeResponse<DataResult<List<StreamingJobResponse>>> getStreamingJobList(@RequestParam(value="model_name", required=false, defaultValue="") String modelName, @RequestParam(value="model_names", required=false) List<String> modelNames, @RequestParam(value="job_types", required=false, defaultValue="") List<String> jobTypes, @RequestParam(value="statuses", required=false, defaultValue="") List<String> statuses, @RequestParam(value="project", required=false, defaultValue="") String project, @RequestParam(value="page_offset", required=false, defaultValue="0") Integer pageOffset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer pageSize, @RequestParam(value="sort_by", required=false, defaultValue="last_modified") String sortBy, @RequestParam(value="reverse", required=false, defaultValue="true") boolean reverse) {
        this.checkStreamingEnabled();
        StreamingJobFilter jobFilter = new StreamingJobFilter(modelName, modelNames, jobTypes, statuses, project, sortBy, reverse);
        DataResult data = this.streamingJobService.getStreamingJobList(jobFilter, pageOffset.intValue(), pageSize.intValue());
        return new EnvelopeResponse("000", (Object)data, "");
    }

    @GetMapping(value={"/model_name"})
    @ResponseBody
    public EnvelopeResponse<List<String>> getStreamingModelNameList(@RequestParam(value="model_name", required=false, defaultValue="") String modelName, @RequestParam(value="project", required=false, defaultValue="") String project, @RequestParam(value="page_size", required=false, defaultValue="10") Integer pageSize) {
        this.checkStreamingEnabled();
        StreamingJobFilter jobFilter = new StreamingJobFilter(modelName, Collections.EMPTY_LIST, Arrays.asList("STREAMING_BUILD"), Collections.EMPTY_LIST, project, "last_modified", true);
        DataResult dataResult = this.streamingJobService.getStreamingJobList(jobFilter, 0, pageSize.intValue());
        List<Object> data = dataResult != null ? ((List)dataResult.getValue()).stream().map(item -> item.getModelName()).collect(Collectors.toList()) : new ArrayList();
        return new EnvelopeResponse("000", data, "");
    }

    @ApiOperation(value="updateStreamingJobStatus", notes="Update Body: jobId")
    @PutMapping(value={"/status"})
    @ResponseBody
    public EnvelopeResponse<String> updateStreamingJobStatus(@RequestBody StreamingJobExecuteRequest streamingJobExecuteRequest) {
        this.checkStreamingEnabled();
        this.checkRequiredArg("action", streamingJobExecuteRequest.getAction());
        this.streamingJobService.updateStreamingJobStatus(streamingJobExecuteRequest.getProject(), streamingJobExecuteRequest.getJobIds(), streamingJobExecuteRequest.getAction());
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @PutMapping(value={"/params"})
    @ResponseBody
    public EnvelopeResponse<String> updateStreamingJobParams(@RequestBody StreamingJobParamsRequest streamingJobParamsRequest) {
        this.checkStreamingEnabled();
        this.checkProjectName(streamingJobParamsRequest.getProject());
        this.streamingJobService.updateStreamingJobParams(streamingJobParamsRequest.getProject(), streamingJobParamsRequest.getJobId(), streamingJobParamsRequest.getParams());
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @GetMapping(value={"/stats/{jobId:.+}"})
    @ResponseBody
    public EnvelopeResponse<StreamingJobDataStatsResponse> getStreamingJobDataStats(@PathVariable(value="jobId") String jobId, @RequestParam(value="project") String project, @RequestParam(value="time_filter", required=false, defaultValue="-1") Integer timeFilter) {
        this.checkStreamingEnabled();
        StreamingJobDataStatsResponse response = this.streamingJobService.getStreamingJobDataStats(jobId, timeFilter);
        return new EnvelopeResponse("000", (Object)response, "");
    }

    @PutMapping(value={"/stats"})
    @ResponseBody
    public EnvelopeResponse<String> collectStreamingJobStats(@RequestBody StreamingJobStatsRequest streamingJobStatsRequest) {
        this.checkStreamingEnabled();
        this.checkProjectName(streamingJobStatsRequest.getProject());
        String jobId = streamingJobStatsRequest.getJobId();
        this.checkToken(streamingJobStatsRequest.getProject(), jobId.substring(0, jobId.lastIndexOf("_")), (StreamingRequestHeader)streamingJobStatsRequest);
        this.streamingJobService.collectStreamingJobStats(streamingJobStatsRequest);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @PutMapping(value={"/spark"})
    @ResponseBody
    public EnvelopeResponse<String> updateStreamingJobInfo(@RequestBody StreamingJobUpdateRequest streamingJobUpdateRequest) {
        this.checkStreamingEnabled();
        this.checkProjectName(streamingJobUpdateRequest.getProject());
        StreamingJobMeta meta = this.streamingJobService.updateStreamingJobInfo(streamingJobUpdateRequest);
        return new EnvelopeResponse("000", (Object)Objects.toString(meta.getJobExecutionId(), null), "");
    }

    @GetMapping(value={"/records"})
    @ResponseBody
    public EnvelopeResponse<List<StreamingJobRecord>> getStreamingJobRecordList(@RequestParam(value="project") String project, @RequestParam(value="job_id") String jobId) {
        this.checkStreamingEnabled();
        this.checkProjectName(project);
        List data = this.streamingJobService.getStreamingJobRecordList(jobId);
        return new EnvelopeResponse("000", (Object)data, "");
    }

    @PostMapping(value={"/dataflow/segment"})
    @ResponseBody
    public RestResponse addSegment(@RequestBody StreamingSegmentRequest request) {
        this.checkStreamingEnabled();
        String project = request.getProject();
        String dataflowId = request.getDataflowId();
        SegmentRange segRange = request.getSegmentRange();
        this.checkProjectName(request.getProject());
        this.checkToken(project, dataflowId, (StreamingRequestHeader)request);
        String newSegId = this.streamingJobService.addSegment(project, dataflowId, segRange, request.getLayer(), request.getNewSegId());
        return new RestResponse((Object)newSegId);
    }

    @PutMapping(value={"/dataflow/segment"})
    @ResponseBody
    public RestResponse updateSegment(@RequestBody StreamingSegmentRequest request) {
        this.checkStreamingEnabled();
        String project = request.getProject();
        String dataflowId = request.getDataflowId();
        String segId = request.getNewSegId();
        List removeSegmentList = request.getRemoveSegment();
        String status = request.getStatus();
        this.checkProjectName(request.getProject());
        this.checkToken(project, dataflowId, (StreamingRequestHeader)request);
        this.streamingJobService.updateSegment(project, dataflowId, segId, removeSegmentList, status, request.getSourceCount());
        return RestResponse.ok();
    }

    @PostMapping(value={"/dataflow/segment/deletion"})
    @ResponseBody
    public RestResponse deleteSegment(@RequestBody StreamingSegmentRequest request) {
        this.checkStreamingEnabled();
        String project = request.getProject();
        String dataflowId = request.getDataflowId();
        List removeSegmentList = request.getRemoveSegment();
        this.checkProjectName(request.getProject());
        this.checkToken(project, dataflowId, (StreamingRequestHeader)request);
        this.streamingJobService.deleteSegment(project, dataflowId, removeSegmentList);
        return RestResponse.ok();
    }

    @PutMapping(value={"/dataflow/layout"})
    @ResponseBody
    public RestResponse updateLayout(@RequestBody LayoutUpdateRequest request) {
        this.checkStreamingEnabled();
        String project = request.getProject();
        String dataflowId = request.getDataflowId();
        List layouts = request.getLayouts();
        List segDetails = request.getSegDetails();
        for (int i = 0; i < layouts.size(); ++i) {
            ((NDataLayout)layouts.get(i)).setSegDetails((NDataSegDetails)segDetails.get(i));
        }
        this.checkProjectName(project);
        this.checkToken(project, dataflowId, (StreamingRequestHeader)request);
        this.streamingJobService.updateLayout(project, dataflowId, layouts);
        return RestResponse.ok();
    }

    private void checkToken(String project, String modelId, StreamingRequestHeader request) {
        int taskId = request.getJobExecutionId();
        String jobType = request.getJobType();
        String jobId = StreamingUtils.getJobId((String)modelId, (String)jobType);
        this.streamingJobService.checkJobExecutionId(project, jobId, Integer.valueOf(taskId));
    }

    @GetMapping(value={"/{job_id:.+}/simple_log"})
    @ResponseBody
    public EnvelopeResponse<Map<String, String>> getStreamingJobDriverLogSimple(@PathVariable(value="job_id") String jobId, @RequestParam(value="project") String project) {
        this.checkStreamingEnabled();
        String projectName = this.checkProjectName(project);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("cmd_output", this.streamingJobService.getStreamingJobSimpleLog(projectName, jobId));
        return new EnvelopeResponse("000", result, "");
    }

    @GetMapping(value={"/{job_id:.+}/download_log"})
    @ResponseBody
    public EnvelopeResponse<String> downloadStreamingJobDriverLog(@PathVariable(value="job_id") String jobId, @RequestParam(value="project") String project, HttpServletResponse response) {
        this.checkStreamingEnabled();
        String projectName = this.checkProjectName(project);
        String downloadFilename = String.format(Locale.ROOT, "%s_%s.log", projectName, jobId);
        InputStream inputStream = this.streamingJobService.getStreamingJobAllLog(projectName, jobId);
        this.setDownloadResponse(inputStream, downloadFilename, "application/octet-stream", response);
        return new EnvelopeResponse("000", (Object)"", "");
    }
}

