/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.cluster.RedisClusterClient;
import java.util.LinkedHashSet;
import org.springframework.data.redis.connection.ClusterTopology;
import org.springframework.data.redis.connection.ClusterTopologyProvider;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.util.Assert;

class LettuceClusterTopologyProvider
implements ClusterTopologyProvider {
    private final RedisClusterClient client;

    LettuceClusterTopologyProvider(RedisClusterClient client) {
        Assert.notNull((Object)client, (String)"RedisClusterClient must not be null.");
        this.client = client;
    }

    @Override
    public ClusterTopology getTopology() {
        return new ClusterTopology(new LinkedHashSet<RedisClusterNode>(LettuceConverters.partitionsToClusterNodes(this.client.getPartitions())));
    }
}

