/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.DefaultBoundKeyOperations;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.lang.Nullable;

class DefaultBoundHashOperations<H, HK, HV>
extends DefaultBoundKeyOperations<H>
implements BoundHashOperations<H, HK, HV> {
    private final HashOperations<H, HK, HV> ops;

    DefaultBoundHashOperations(H key, RedisOperations<H, ?> operations) {
        super(key, operations);
        this.ops = operations.opsForHash();
    }

    @Override
    public Long delete(Object ... keys) {
        return this.ops.delete(this.getKey(), keys);
    }

    @Override
    public HV get(Object key) {
        return this.ops.get(this.getKey(), key);
    }

    @Override
    public List<HV> multiGet(Collection<HK> hashKeys) {
        return this.ops.multiGet(this.getKey(), hashKeys);
    }

    @Override
    public RedisOperations<H, ?> getOperations() {
        return this.ops.getOperations();
    }

    @Override
    public Boolean hasKey(Object key) {
        return this.ops.hasKey(this.getKey(), key);
    }

    @Override
    public Long increment(HK key, long delta) {
        return this.ops.increment(this.getKey(), key, delta);
    }

    @Override
    public Double increment(HK key, double delta) {
        return this.ops.increment(this.getKey(), key, delta);
    }

    @Override
    @Nullable
    public HK randomKey() {
        return this.ops.randomKey(this.getKey());
    }

    @Override
    @Nullable
    public Map.Entry<HK, HV> randomEntry() {
        return this.ops.randomEntry(this.getKey());
    }

    @Override
    @Nullable
    public List<HK> randomKeys(long count) {
        return this.ops.randomKeys(this.getKey(), count);
    }

    @Override
    @Nullable
    public Map<HK, HV> randomEntries(long count) {
        return this.ops.randomEntries(this.getKey(), count);
    }

    @Override
    public Set<HK> keys() {
        return this.ops.keys(this.getKey());
    }

    @Override
    @Nullable
    public Long lengthOfValue(HK hashKey) {
        return this.ops.lengthOfValue(this.getKey(), hashKey);
    }

    @Override
    public Long size() {
        return this.ops.size(this.getKey());
    }

    @Override
    public void putAll(Map<? extends HK, ? extends HV> m) {
        this.ops.putAll(this.getKey(), m);
    }

    @Override
    public void put(HK key, HV value) {
        this.ops.put(this.getKey(), key, value);
    }

    @Override
    public Boolean putIfAbsent(HK key, HV value) {
        return this.ops.putIfAbsent(this.getKey(), key, value);
    }

    @Override
    public List<HV> values() {
        return this.ops.values(this.getKey());
    }

    @Override
    public Map<HK, HV> entries() {
        return this.ops.entries(this.getKey());
    }

    @Override
    public DataType getType() {
        return DataType.HASH;
    }

    @Override
    public Cursor<Map.Entry<HK, HV>> scan(ScanOptions options) {
        return this.ops.scan(this.getKey(), options);
    }
}

