/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.config.initialize;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCode;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeCommon;
import org.apache.kylin.common.exception.code.ErrorMsg;
import org.apache.kylin.common.exception.code.ErrorSuggestion;
import org.apache.kylin.common.metrics.MetricsCategory;
import org.apache.kylin.common.metrics.MetricsGroup;
import org.apache.kylin.common.metrics.MetricsName;
import org.apache.kylin.common.metrics.MetricsTag;
import org.apache.kylin.common.metrics.prometheus.PrometheusMetrics;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.scheduler.JobFinishedNotifier;
import org.apache.kylin.common.scheduler.JobReadyNotifier;
import org.apache.kylin.common.util.AddressUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.engine.spark.job.NSparkCubingJob;
import org.apache.kylin.guava30.shaded.common.base.Throwables;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.eventbus.Subscribe;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.manager.SegmentAutoMergeUtil;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.model.MultiPartitionDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TimeRange;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.rest.constant.SnapshotStatus;
import org.apache.kylin.rest.response.SegmentPartitionResponse;
import org.apache.kylin.rest.util.SpringContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JobSyncListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobSyncListener.class);
    private static final long RETRY_INTERVAL = 5000L;
    private static final int MAX_RETRY_COUNT = 5;
    private static String URL;
    private boolean jobReadyNotified = false;
    private boolean jobFinishedNotified = false;

    @Subscribe
    public void onJobIsReady(JobReadyNotifier notifier) {
        this.jobReadyNotified = true;
    }

    @Subscribe
    public void onJobFinished(JobFinishedNotifier notifier) {
        try {
            JobSyncListener.postJobInfo(JobSyncListener.extractJobInfo(notifier));
        }
        finally {
            this.updateMetrics(notifier);
        }
    }

    @Subscribe
    public void onBuildJobFinished(JobFinishedNotifier notifier) {
        try {
            if (notifier.getJobClass().equals(NSparkCubingJob.class.getName()) && notifier.isSucceed()) {
                SegmentAutoMergeUtil.autoMergeSegments((String)notifier.getProject(), (String)notifier.getSubject(), (String)notifier.getOwner());
            }
        }
        catch (Exception e) {
            log.error("Auto merge failed on project {} model {}", new Object[]{notifier.getProject(), notifier.getSubject(), e});
        }
    }

    private static void setLanguage(String lang) {
        MsgPicker.setMsg((String)lang);
        ErrorCode.setMsg((String)lang);
        ErrorMsg.setMsg((String)lang);
        ErrorSuggestion.setMsg((String)lang);
    }

    private static KylinConfig getOverrideConfig(String project) {
        KylinConfig originalConfig = KylinConfig.getInstanceFromEnv();
        ProjectInstance projectInstance = NProjectManager.getInstance((KylinConfig)originalConfig).getProject(project);
        return projectInstance.getConfig();
    }

    static JobInfo extractJobInfo(JobFinishedNotifier notifier) {
        ArrayList segRangeList = Lists.newArrayList();
        ArrayList segmentPartitionsInfoList = Lists.newArrayList();
        String project = notifier.getProject();
        String subject = notifier.getSubject();
        NTableMetadataManager nTableMetadataManager = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        TableDesc tableDesc = nTableMetadataManager.getTableDesc(subject);
        if (tableDesc == null) {
            Set segmentIds = notifier.getSegmentIds();
            NDataflowManager nDataflowManager = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
            NDataflow dataflow = nDataflowManager.getDataflow(subject);
            if (dataflow != null && CollectionUtils.isNotEmpty((Collection)segmentIds)) {
                NDataModel model = dataflow.getModel();
                MultiPartitionDesc partitionDesc = model.getMultiPartitionDesc();
                segmentIds.forEach(id -> {
                    NDataSegment segment = dataflow.getSegment(id);
                    if (segment == null) {
                        return;
                    }
                    TimeRange segRange = segment.getTSRange();
                    segRangeList.add(new SegRange((String)id, segRange.getStart(), segRange.getEnd()));
                    if (partitionDesc != null && notifier.getSegmentPartitionsMap().get(id) != null && !((Set)notifier.getSegmentPartitionsMap().get(id)).isEmpty()) {
                        List<SegmentPartitionResponse> segmentPartitionResponseList = segment.getMultiPartitions().stream().filter(segmentPartition -> ((Set)notifier.getSegmentPartitionsMap().get(id)).contains(segmentPartition.getPartitionId())).map(partition -> {
                            MultiPartitionDesc.PartitionInfo partitionInfo = partitionDesc.getPartitionInfo(partition.getPartitionId());
                            return new SegmentPartitionResponse(partitionInfo.getId(), partitionInfo.getValues(), partition.getStatus(), partition.getLastBuildTime(), partition.getSourceCount(), partition.getStorageSize());
                        }).collect(Collectors.toList());
                        segmentPartitionsInfoList.add(new SegmentPartitionsInfo((String)id, segmentPartitionResponseList));
                    }
                });
            }
        }
        String errorCode = null;
        String suggestion = null;
        String msg = null;
        String code = null;
        String stacktrace = null;
        Throwable throwable = notifier.getThrowable();
        if (throwable != null) {
            Throwable rootCause = Throwables.getRootCause((Throwable)throwable);
            KylinConfig kylinConfig = JobSyncListener.getOverrideConfig(project);
            JobSyncListener.setLanguage(kylinConfig.getJobCallbackLanguage());
            if (rootCause instanceof KylinException) {
                msg = rootCause.getLocalizedMessage();
                KylinException kylinException = (KylinException)rootCause;
                code = kylinException.getCode();
                suggestion = kylinException.getSuggestionString();
                errorCode = kylinException.getErrorCodeString();
                stacktrace = Throwables.getStackTraceAsString((Throwable)rootCause);
            } else {
                errorCode = ErrorCodeCommon.NON_KE_EXCEPTION.getErrorCode().getCode();
                msg = ErrorCodeCommon.NON_KE_EXCEPTION.getCodeMsg(new Object[0]);
                suggestion = ErrorCodeCommon.NON_KE_EXCEPTION.getErrorSuggest().getLocalizedString();
                code = "999";
                stacktrace = Throwables.getStackTraceAsString((Throwable)throwable);
            }
        }
        return JobInfo.builder().jobId(notifier.getJobId()).project(notifier.getProject()).modelId(tableDesc == null ? notifier.getSubject() : null).segmentIds(notifier.getSegmentIds()).indexIds(notifier.getLayoutIds()).duration(notifier.getDuration()).state("SUICIDAL".equalsIgnoreCase(notifier.getJobState()) ? "DISCARDED" : notifier.getJobState()).jobType(notifier.getJobType()).segRanges(segRangeList).segmentPartitionInfoList(segmentPartitionsInfoList).snapshotJobInfo(JobSyncListener.getSnapshotJobInfo(tableDesc, notifier)).startTime(notifier.getStartTime()).endTime(notifier.getEndTime()).tag(notifier.getTag()).errorCode(errorCode).suggestion(suggestion).msg(msg).code(code).stacktrace(stacktrace).build();
    }

    private static SnapshotJobInfo getSnapshotJobInfo(TableDesc tableDesc, JobFinishedNotifier notifier) {
        SnapshotJobInfo snapshotJobInfo = null;
        if (tableDesc != null && (JobTypeEnum.SNAPSHOT_BUILD.toString().equals(notifier.getJobType()) || JobTypeEnum.SNAPSHOT_REFRESH.toString().equals(notifier.getJobType()))) {
            snapshotJobInfo = SnapshotJobInfo.builder().table(tableDesc.getName()).database(tableDesc.getDatabase()).totalRows(tableDesc.getSnapshotTotalRows()).storage(tableDesc.getLastSnapshotSize()).status(JobSyncListener.getSnapshotJobStatus(tableDesc)).lastModifiedTime(tableDesc.getSnapshotLastModified()).selectPartitionCol(tableDesc.getSelectedSnapshotPartitionCol()).build();
        }
        return snapshotJobInfo;
    }

    static void postJobInfo(JobInfo info) {
        URL = KylinConfig.getInstanceFromEnv().getJobFinishedNotifierUrl();
        log.info("post job info parameter, url : {}, state : {}, segmentId : {}, table : {}", new Object[]{URL, info.getState(), info.getSegmentIds(), info.getSnapshotJobInfo() != null ? info.getSnapshotJobInfo().getDatabase() + "." + info.getSnapshotJobInfo().getTable() : null});
        if (URL == null || "READY".equalsIgnoreCase(info.getState())) {
            return;
        }
        RequestConfig config = RequestConfig.custom().setSocketTimeout(3000).build();
        try (CloseableHttpClient httpClient = HttpClients.custom().setSSLContext(JobSyncListener.getTrustAllSSLContext()).setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).setDefaultRequestConfig(config).setRetryHandler((HttpRequestRetryHandler)new SimpleHttpRequestRetryHandler()).setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)new SimpleServiceUnavailableRetryStrategy()).build();){
            HttpPost httpPost = new HttpPost(URL);
            httpPost.addHeader("Content-Type", "application/json");
            String username = KylinConfig.getInstanceFromEnv().getJobFinishedNotifierUsername();
            String password = KylinConfig.getInstanceFromEnv().getJobFinishedNotifierPassword();
            if (username != null && password != null) {
                log.info("use basic auth.");
                String basicToken = JobSyncListener.makeToken(username, password);
                httpPost.addHeader("Authorization", basicToken);
            }
            httpPost.setEntity((HttpEntity)new StringEntity(JsonUtil.writeValueAsString((Object)info), StandardCharsets.UTF_8));
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            int code = response.getStatusLine().getStatusCode();
            if (code == 200) {
                log.info("Post job info to " + URL + " successful.");
            } else {
                log.info("Post job info to " + URL + " failed. Status code: " + code);
            }
        }
        catch (IOException e) {
            log.warn("Error occurred when post job status.", (Throwable)e);
        }
    }

    private static SnapshotStatus getSnapshotJobStatus(TableDesc tableDesc) {
        if (tableDesc.isSnapshotHasBroken()) {
            return SnapshotStatus.BROKEN;
        }
        boolean hasSnapshot = StringUtils.isNotEmpty((CharSequence)tableDesc.getLastSnapshotPath());
        if (hasSnapshot) {
            return SnapshotStatus.ONLINE;
        }
        return SnapshotStatus.OFFLINE;
    }

    public static SSLContext getTrustAllSSLContext() {
        return new SSLContextBuilder().loadTrustMaterial(null, (chain, authType) -> true).build();
    }

    private static String makeToken(String username, String password) {
        String rawTokenString = String.format(Locale.ROOT, "%s:%s", username, password);
        return "Basic " + Base64.getEncoder().encodeToString(rawTokenString.getBytes(Charset.defaultCharset()));
    }

    private void updateMetrics(JobFinishedNotifier notifier) {
        try {
            log.info("Update metrics for {}, duration is {}, waitTime is {}, jobType is {}, state is {}, subject is {}", new Object[]{notifier.getJobId(), notifier.getDuration(), notifier.getWaitTime(), notifier.getJobType(), notifier.getJobState(), notifier.getSubject()});
            ExecutableState state = ExecutableState.valueOf((String)notifier.getJobState());
            String project = notifier.getProject();
            NDataflowManager manager = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
            NDataflow dataflow = manager.getDataflow(notifier.getSubject());
            this.recordPrometheusMetric(notifier, (MeterRegistry)SpringContext.getBean(MeterRegistry.class), dataflow == null ? "" : dataflow.getModelAlias(), state);
            if (state.isFinalState()) {
                long duration = notifier.getDuration();
                MetricsGroup.hostTagCounterInc((MetricsName)MetricsName.JOB_FINISHED, (MetricsCategory)MetricsCategory.PROJECT, (String)project);
                MetricsGroup.hostTagCounterInc((MetricsName)MetricsName.JOB_DURATION, (MetricsCategory)MetricsCategory.PROJECT, (String)project, (long)duration);
                MetricsGroup.hostTagHistogramUpdate((MetricsName)MetricsName.JOB_DURATION_HISTOGRAM, (MetricsCategory)MetricsCategory.PROJECT, (String)project, (long)duration);
                MetricsGroup.hostTagCounterInc((MetricsName)MetricsName.JOB_WAIT_DURATION, (MetricsCategory)MetricsCategory.PROJECT, (String)project, (long)duration);
                if (dataflow != null) {
                    String modelAlias = dataflow.getModelAlias();
                    HashMap tags = Maps.newHashMap();
                    tags.put(MetricsTag.MODEL.getVal(), project.concat("-").concat(modelAlias));
                    MetricsGroup.counterInc((MetricsName)MetricsName.MODEL_BUILD_DURATION, (MetricsCategory)MetricsCategory.PROJECT, (String)project, (Map)tags, (long)duration);
                    MetricsGroup.counterInc((MetricsName)MetricsName.MODEL_WAIT_DURATION, (MetricsCategory)MetricsCategory.PROJECT, (String)project, (Map)tags, (long)notifier.getWaitTime());
                    MetricsGroup.histogramUpdate((MetricsName)MetricsName.MODEL_BUILD_DURATION_HISTOGRAM, (MetricsCategory)MetricsCategory.PROJECT, (String)project, (Map)tags, (long)duration);
                }
                Map<String, String> tags = this.getJobStatisticsTags(notifier.getJobType());
                if (state == ExecutableState.SUCCEED) {
                    MetricsGroup.counterInc((MetricsName)MetricsName.SUCCESSFUL_JOB_COUNT, (MetricsCategory)MetricsCategory.PROJECT, (String)project, tags);
                } else if (ExecutableState.ERROR == state) {
                    MetricsGroup.hostTagCounterInc((MetricsName)MetricsName.JOB_ERROR, (MetricsCategory)MetricsCategory.PROJECT, (String)project);
                    MetricsGroup.counterInc((MetricsName)MetricsName.ERROR_JOB_COUNT, (MetricsCategory)MetricsCategory.PROJECT, (String)project, tags);
                }
                if (duration <= 300000L) {
                    MetricsGroup.counterInc((MetricsName)MetricsName.JOB_COUNT_LT_5, (MetricsCategory)MetricsCategory.PROJECT, (String)project, tags);
                } else if (duration <= 600000L) {
                    MetricsGroup.counterInc((MetricsName)MetricsName.JOB_COUNT_5_10, (MetricsCategory)MetricsCategory.PROJECT, (String)project, tags);
                } else if (duration <= 1800000L) {
                    MetricsGroup.counterInc((MetricsName)MetricsName.JOB_COUNT_10_30, (MetricsCategory)MetricsCategory.PROJECT, (String)project, tags);
                } else if (duration <= 3600000L) {
                    MetricsGroup.counterInc((MetricsName)MetricsName.JOB_COUNT_30_60, (MetricsCategory)MetricsCategory.PROJECT, (String)project, tags);
                } else {
                    MetricsGroup.counterInc((MetricsName)MetricsName.JOB_COUNT_GT_60, (MetricsCategory)MetricsCategory.PROJECT, (String)project, tags);
                }
                MetricsGroup.counterInc((MetricsName)MetricsName.JOB_TOTAL_DURATION, (MetricsCategory)MetricsCategory.PROJECT, (String)project, tags, (long)duration);
            }
        }
        catch (Exception e) {
            log.error("Fail to update metrics.", (Throwable)e);
        }
    }

    public void recordPrometheusMetric(JobFinishedNotifier notifier, MeterRegistry meterRegistry, String modelAlias, ExecutableState state) {
        if (!KylinConfig.getInstanceFromEnv().isPrometheusMetricsEnabled()) {
            return;
        }
        if (state.isFinalState() || ExecutableState.ERROR == state) {
            JobTypeEnum jobTypeEnum = JobTypeEnum.getEnumByName((String)notifier.getJobType());
            DistributionSummary.builder((String)PrometheusMetrics.JOB_MINUTES.getValue()).tags(new String[]{MetricsTag.PROJECT.getVal(), notifier.getProject(), MetricsTag.SUCCEED.getVal(), (ExecutableState.SUCCEED == state) + "", MetricsTag.JOB_CATEGORY.getVal(), Objects.isNull(jobTypeEnum) ? "" : jobTypeEnum.getCategory()}).distributionStatisticExpiry(Duration.ofDays(1L)).register(meterRegistry).record((double)(notifier.getDuration() + notifier.getWaitTime()) / 60000.0);
            if (StringUtils.isEmpty((CharSequence)modelAlias)) {
                return;
            }
            boolean containPrometheusJobTypeFlag = JobTypeEnum.getJobTypeByCategory((String)"BUILD").stream().anyMatch(e -> e.toString().equals(notifier.getJobType()));
            if (containPrometheusJobTypeFlag) {
                DistributionSummary.builder((String)PrometheusMetrics.MODEL_BUILD_DURATION.getValue()).tags(new String[]{MetricsTag.MODEL.getVal(), modelAlias, MetricsTag.PROJECT.getVal(), notifier.getProject(), MetricsTag.JOB_TYPE.getVal(), notifier.getJobType(), MetricsTag.SUCCEED.getVal(), String.valueOf(ExecutableState.SUCCEED == state)}).distributionStatisticExpiry(Duration.ofDays(1L)).sla(KylinConfig.getInstanceFromEnv().getMetricsJobSlaMinutes()).register(meterRegistry).record((double)(notifier.getDuration() + notifier.getWaitTime()) / 60000.0);
            }
        }
    }

    private Map<String, String> getJobStatisticsTags(String jobType) {
        HashMap tags = Maps.newHashMap();
        tags.put(MetricsTag.HOST.getVal(), AddressUtil.getZkLocalInstance());
        tags.put(MetricsTag.JOB_TYPE.getVal(), jobType);
        return tags;
    }

    @Generated
    public boolean isJobReadyNotified() {
        return this.jobReadyNotified;
    }

    @Generated
    public void setJobReadyNotified(boolean jobReadyNotified) {
        this.jobReadyNotified = jobReadyNotified;
    }

    @Generated
    public boolean isJobFinishedNotified() {
        return this.jobFinishedNotified;
    }

    @Generated
    public void setJobFinishedNotified(boolean jobFinishedNotified) {
        this.jobFinishedNotified = jobFinishedNotified;
    }

    static class SnapshotJobInfo {
        @JsonProperty(value="table")
        private String table;
        @JsonProperty(value="database")
        private String database;
        @JsonProperty(value="total_rows")
        private long totalRows;
        @JsonProperty(value="storage")
        private long storage;
        @JsonProperty(value="last_modified_time")
        private long lastModifiedTime;
        @JsonProperty(value="status")
        private SnapshotStatus status;
        @JsonProperty(value="select_partition_col")
        private String selectPartitionCol;

        @Generated
        SnapshotJobInfo(String table, String database, long totalRows, long storage, long lastModifiedTime, SnapshotStatus status, String selectPartitionCol) {
            this.table = table;
            this.database = database;
            this.totalRows = totalRows;
            this.storage = storage;
            this.lastModifiedTime = lastModifiedTime;
            this.status = status;
            this.selectPartitionCol = selectPartitionCol;
        }

        @Generated
        public static SnapshotJobInfoBuilder builder() {
            return new SnapshotJobInfoBuilder();
        }

        @Generated
        public void setTable(String table) {
            this.table = table;
        }

        @Generated
        public void setDatabase(String database) {
            this.database = database;
        }

        @Generated
        public void setTotalRows(long totalRows) {
            this.totalRows = totalRows;
        }

        @Generated
        public void setStorage(long storage) {
            this.storage = storage;
        }

        @Generated
        public void setLastModifiedTime(long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Generated
        public void setStatus(SnapshotStatus status) {
            this.status = status;
        }

        @Generated
        public void setSelectPartitionCol(String selectPartitionCol) {
            this.selectPartitionCol = selectPartitionCol;
        }

        @Generated
        public String getTable() {
            return this.table;
        }

        @Generated
        public String getDatabase() {
            return this.database;
        }

        @Generated
        public long getTotalRows() {
            return this.totalRows;
        }

        @Generated
        public long getStorage() {
            return this.storage;
        }

        @Generated
        public long getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Generated
        public SnapshotStatus getStatus() {
            return this.status;
        }

        @Generated
        public String getSelectPartitionCol() {
            return this.selectPartitionCol;
        }

        @Generated
        public static class SnapshotJobInfoBuilder {
            @Generated
            private String table;
            @Generated
            private String database;
            @Generated
            private long totalRows;
            @Generated
            private long storage;
            @Generated
            private long lastModifiedTime;
            @Generated
            private SnapshotStatus status;
            @Generated
            private String selectPartitionCol;

            @Generated
            SnapshotJobInfoBuilder() {
            }

            @Generated
            public SnapshotJobInfoBuilder table(String table) {
                this.table = table;
                return this;
            }

            @Generated
            public SnapshotJobInfoBuilder database(String database) {
                this.database = database;
                return this;
            }

            @Generated
            public SnapshotJobInfoBuilder totalRows(long totalRows) {
                this.totalRows = totalRows;
                return this;
            }

            @Generated
            public SnapshotJobInfoBuilder storage(long storage) {
                this.storage = storage;
                return this;
            }

            @Generated
            public SnapshotJobInfoBuilder lastModifiedTime(long lastModifiedTime) {
                this.lastModifiedTime = lastModifiedTime;
                return this;
            }

            @Generated
            public SnapshotJobInfoBuilder status(SnapshotStatus status) {
                this.status = status;
                return this;
            }

            @Generated
            public SnapshotJobInfoBuilder selectPartitionCol(String selectPartitionCol) {
                this.selectPartitionCol = selectPartitionCol;
                return this;
            }

            @Generated
            public SnapshotJobInfo build() {
                return new SnapshotJobInfo(this.table, this.database, this.totalRows, this.storage, this.lastModifiedTime, this.status, this.selectPartitionCol);
            }

            @Generated
            public String toString() {
                return "JobSyncListener.SnapshotJobInfo.SnapshotJobInfoBuilder(table=" + this.table + ", database=" + this.database + ", totalRows=" + this.totalRows + ", storage=" + this.storage + ", lastModifiedTime=" + this.lastModifiedTime + ", status=" + this.status + ", selectPartitionCol=" + this.selectPartitionCol + ")";
            }
        }
    }

    static class SegmentPartitionsInfo {
        @JsonProperty(value="segment_id")
        private String segmentId;
        @JsonProperty(value="partition_info")
        private List<SegmentPartitionResponse> partitionInfo;

        public SegmentPartitionsInfo(String segmentId, List<SegmentPartitionResponse> segmentPartitionResponseList) {
            this.segmentId = segmentId;
            this.partitionInfo = segmentPartitionResponseList;
        }

        @Generated
        public void setSegmentId(String segmentId) {
            this.segmentId = segmentId;
        }

        @Generated
        public void setPartitionInfo(List<SegmentPartitionResponse> partitionInfo) {
            this.partitionInfo = partitionInfo;
        }

        @Generated
        public String getSegmentId() {
            return this.segmentId;
        }

        @Generated
        public List<SegmentPartitionResponse> getPartitionInfo() {
            return this.partitionInfo;
        }
    }

    static class SegRange {
        @JsonProperty(value="segment_id")
        private String segmentId;
        @JsonProperty(value="data_range_start")
        private long start;
        @JsonProperty(value="data_range_end")
        private long end;

        public SegRange(String id, long start, long end) {
            this.segmentId = id;
            this.start = start;
            this.end = end;
        }

        @Generated
        public void setSegmentId(String segmentId) {
            this.segmentId = segmentId;
        }

        @Generated
        public void setStart(long start) {
            this.start = start;
        }

        @Generated
        public void setEnd(long end) {
            this.end = end;
        }

        @Generated
        public String getSegmentId() {
            return this.segmentId;
        }

        @Generated
        public long getStart() {
            return this.start;
        }

        @Generated
        public long getEnd() {
            return this.end;
        }
    }

    public static class JobInfo {
        @JsonProperty(value="job_id")
        private String jobId;
        @JsonProperty(value="project")
        private String project;
        @JsonProperty(value="model_id")
        private String modelId;
        @JsonProperty(value="segment_ids")
        private Set<String> segmentIds;
        @JsonProperty(value="index_ids")
        private Set<Long> indexIds;
        @JsonProperty(value="duration")
        private long duration;
        @JsonProperty(value="job_state")
        private String state;
        @JsonProperty(value="job_type")
        private String jobType;
        @JsonProperty(value="segment_time_range")
        private List<SegRange> segRanges;
        @JsonProperty(value="segment_partition_info")
        private List<SegmentPartitionsInfo> segmentPartitionInfoList;
        @JsonProperty(value="snapshot_job_info")
        private SnapshotJobInfo snapshotJobInfo;
        @JsonProperty(value="start_time")
        private long startTime;
        @JsonProperty(value="end_time")
        private long endTime;
        @JsonProperty(value="tag")
        private Object tag;
        @JsonProperty(value="error_code")
        private String errorCode;
        @JsonProperty(value="suggestion")
        private String suggestion;
        @JsonProperty(value="msg")
        private String msg;
        @JsonProperty(value="code")
        private String code;
        @JsonProperty(value="stacktrace")
        private String stacktrace;

        @Generated
        JobInfo(String jobId, String project, String modelId, Set<String> segmentIds, Set<Long> indexIds, long duration, String state, String jobType, List<SegRange> segRanges, List<SegmentPartitionsInfo> segmentPartitionInfoList, SnapshotJobInfo snapshotJobInfo, long startTime, long endTime, Object tag, String errorCode, String suggestion, String msg, String code, String stacktrace) {
            this.jobId = jobId;
            this.project = project;
            this.modelId = modelId;
            this.segmentIds = segmentIds;
            this.indexIds = indexIds;
            this.duration = duration;
            this.state = state;
            this.jobType = jobType;
            this.segRanges = segRanges;
            this.segmentPartitionInfoList = segmentPartitionInfoList;
            this.snapshotJobInfo = snapshotJobInfo;
            this.startTime = startTime;
            this.endTime = endTime;
            this.tag = tag;
            this.errorCode = errorCode;
            this.suggestion = suggestion;
            this.msg = msg;
            this.code = code;
            this.stacktrace = stacktrace;
        }

        @Generated
        public static JobInfoBuilder builder() {
            return new JobInfoBuilder();
        }

        @Generated
        public String getJobId() {
            return this.jobId;
        }

        @Generated
        public String getProject() {
            return this.project;
        }

        @Generated
        public String getModelId() {
            return this.modelId;
        }

        @Generated
        public Set<String> getSegmentIds() {
            return this.segmentIds;
        }

        @Generated
        public Set<Long> getIndexIds() {
            return this.indexIds;
        }

        @Generated
        public long getDuration() {
            return this.duration;
        }

        @Generated
        public String getState() {
            return this.state;
        }

        @Generated
        public String getJobType() {
            return this.jobType;
        }

        @Generated
        public List<SegRange> getSegRanges() {
            return this.segRanges;
        }

        @Generated
        public List<SegmentPartitionsInfo> getSegmentPartitionInfoList() {
            return this.segmentPartitionInfoList;
        }

        @Generated
        public SnapshotJobInfo getSnapshotJobInfo() {
            return this.snapshotJobInfo;
        }

        @Generated
        public long getStartTime() {
            return this.startTime;
        }

        @Generated
        public long getEndTime() {
            return this.endTime;
        }

        @Generated
        public Object getTag() {
            return this.tag;
        }

        @Generated
        public String getErrorCode() {
            return this.errorCode;
        }

        @Generated
        public String getSuggestion() {
            return this.suggestion;
        }

        @Generated
        public String getMsg() {
            return this.msg;
        }

        @Generated
        public String getCode() {
            return this.code;
        }

        @Generated
        public String getStacktrace() {
            return this.stacktrace;
        }

        @Generated
        public void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Generated
        public void setProject(String project) {
            this.project = project;
        }

        @Generated
        public void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Generated
        public void setSegmentIds(Set<String> segmentIds) {
            this.segmentIds = segmentIds;
        }

        @Generated
        public void setIndexIds(Set<Long> indexIds) {
            this.indexIds = indexIds;
        }

        @Generated
        public void setDuration(long duration) {
            this.duration = duration;
        }

        @Generated
        public void setState(String state) {
            this.state = state;
        }

        @Generated
        public void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Generated
        public void setSegRanges(List<SegRange> segRanges) {
            this.segRanges = segRanges;
        }

        @Generated
        public void setSegmentPartitionInfoList(List<SegmentPartitionsInfo> segmentPartitionInfoList) {
            this.segmentPartitionInfoList = segmentPartitionInfoList;
        }

        @Generated
        public void setSnapshotJobInfo(SnapshotJobInfo snapshotJobInfo) {
            this.snapshotJobInfo = snapshotJobInfo;
        }

        @Generated
        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        @Generated
        public void setEndTime(long endTime) {
            this.endTime = endTime;
        }

        @Generated
        public void setTag(Object tag) {
            this.tag = tag;
        }

        @Generated
        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Generated
        public void setSuggestion(String suggestion) {
            this.suggestion = suggestion;
        }

        @Generated
        public void setMsg(String msg) {
            this.msg = msg;
        }

        @Generated
        public void setCode(String code) {
            this.code = code;
        }

        @Generated
        public void setStacktrace(String stacktrace) {
            this.stacktrace = stacktrace;
        }

        @Generated
        public static class JobInfoBuilder {
            @Generated
            private String jobId;
            @Generated
            private String project;
            @Generated
            private String modelId;
            @Generated
            private Set<String> segmentIds;
            @Generated
            private Set<Long> indexIds;
            @Generated
            private long duration;
            @Generated
            private String state;
            @Generated
            private String jobType;
            @Generated
            private List<SegRange> segRanges;
            @Generated
            private List<SegmentPartitionsInfo> segmentPartitionInfoList;
            @Generated
            private SnapshotJobInfo snapshotJobInfo;
            @Generated
            private long startTime;
            @Generated
            private long endTime;
            @Generated
            private Object tag;
            @Generated
            private String errorCode;
            @Generated
            private String suggestion;
            @Generated
            private String msg;
            @Generated
            private String code;
            @Generated
            private String stacktrace;

            @Generated
            JobInfoBuilder() {
            }

            @Generated
            public JobInfoBuilder jobId(String jobId) {
                this.jobId = jobId;
                return this;
            }

            @Generated
            public JobInfoBuilder project(String project) {
                this.project = project;
                return this;
            }

            @Generated
            public JobInfoBuilder modelId(String modelId) {
                this.modelId = modelId;
                return this;
            }

            @Generated
            public JobInfoBuilder segmentIds(Set<String> segmentIds) {
                this.segmentIds = segmentIds;
                return this;
            }

            @Generated
            public JobInfoBuilder indexIds(Set<Long> indexIds) {
                this.indexIds = indexIds;
                return this;
            }

            @Generated
            public JobInfoBuilder duration(long duration) {
                this.duration = duration;
                return this;
            }

            @Generated
            public JobInfoBuilder state(String state) {
                this.state = state;
                return this;
            }

            @Generated
            public JobInfoBuilder jobType(String jobType) {
                this.jobType = jobType;
                return this;
            }

            @Generated
            public JobInfoBuilder segRanges(List<SegRange> segRanges) {
                this.segRanges = segRanges;
                return this;
            }

            @Generated
            public JobInfoBuilder segmentPartitionInfoList(List<SegmentPartitionsInfo> segmentPartitionInfoList) {
                this.segmentPartitionInfoList = segmentPartitionInfoList;
                return this;
            }

            @Generated
            public JobInfoBuilder snapshotJobInfo(SnapshotJobInfo snapshotJobInfo) {
                this.snapshotJobInfo = snapshotJobInfo;
                return this;
            }

            @Generated
            public JobInfoBuilder startTime(long startTime) {
                this.startTime = startTime;
                return this;
            }

            @Generated
            public JobInfoBuilder endTime(long endTime) {
                this.endTime = endTime;
                return this;
            }

            @Generated
            public JobInfoBuilder tag(Object tag) {
                this.tag = tag;
                return this;
            }

            @Generated
            public JobInfoBuilder errorCode(String errorCode) {
                this.errorCode = errorCode;
                return this;
            }

            @Generated
            public JobInfoBuilder suggestion(String suggestion) {
                this.suggestion = suggestion;
                return this;
            }

            @Generated
            public JobInfoBuilder msg(String msg) {
                this.msg = msg;
                return this;
            }

            @Generated
            public JobInfoBuilder code(String code) {
                this.code = code;
                return this;
            }

            @Generated
            public JobInfoBuilder stacktrace(String stacktrace) {
                this.stacktrace = stacktrace;
                return this;
            }

            @Generated
            public JobInfo build() {
                return new JobInfo(this.jobId, this.project, this.modelId, this.segmentIds, this.indexIds, this.duration, this.state, this.jobType, this.segRanges, this.segmentPartitionInfoList, this.snapshotJobInfo, this.startTime, this.endTime, this.tag, this.errorCode, this.suggestion, this.msg, this.code, this.stacktrace);
            }

            @Generated
            public String toString() {
                return "JobSyncListener.JobInfo.JobInfoBuilder(jobId=" + this.jobId + ", project=" + this.project + ", modelId=" + this.modelId + ", segmentIds=" + this.segmentIds + ", indexIds=" + this.indexIds + ", duration=" + this.duration + ", state=" + this.state + ", jobType=" + this.jobType + ", segRanges=" + this.segRanges + ", segmentPartitionInfoList=" + this.segmentPartitionInfoList + ", snapshotJobInfo=" + this.snapshotJobInfo + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", tag=" + this.tag + ", errorCode=" + this.errorCode + ", suggestion=" + this.suggestion + ", msg=" + this.msg + ", code=" + this.code + ", stacktrace=" + this.stacktrace + ")";
            }
        }
    }

    private static class SimpleServiceUnavailableRetryStrategy
    implements ServiceUnavailableRetryStrategy {
        private SimpleServiceUnavailableRetryStrategy() {
        }

        public boolean retryRequest(HttpResponse httpResponse, int executionCount, HttpContext httpContext) {
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            log.info("url: {}, status code: {}, execution count: {}", new Object[]{URL, statusCode, executionCount});
            return executionCount < 5 && statusCode != 200;
        }

        public long getRetryInterval() {
            return 5000L;
        }
    }

    private static class SimpleHttpRequestRetryHandler
    implements HttpRequestRetryHandler {
        private SimpleHttpRequestRetryHandler() {
        }

        public boolean retryRequest(IOException exception, int retryTimes, HttpContext httpContext) {
            if (exception == null) {
                return false;
            }
            log.info("Trigger SimpleHttpRequestRetryHandler, url: {}, exception: {}, retryTimes: {}", new Object[]{URL, exception.getClass().getName(), retryTimes});
            return retryTimes < 5;
        }
    }
}

