/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten;

import java.io.InputStream;
import java.util.Properties;
import org.apache.gluten.exception.GlutenException;
import scala.Function0;
import scala.Serializable;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

public final class GlutenBuildInfo$ {
    public static GlutenBuildInfo$ MODULE$;
    private final String buildFile;
    private final InputStream buildFileStream;
    private final String unknown;
    private final Properties props;
    private final String VERSION;
    private final String GCC_VERSION;
    private final String JAVA_COMPILE_VERSION;
    private final String SCALA_COMPILE_VERSION;
    private final String SPARK_COMPILE_VERSION;
    private final String HADOOP_COMPILE_VERSION;
    private final String BRANCH;
    private final String REVISION;
    private final String REVISION_TIME;
    private final String BUILD_DATE;
    private final String REPO_URL;
    private final String VELOX_BRANCH;
    private final String VELOX_REVISION;
    private final String VELOX_REVISION_TIME;
    private final String CH_BRANCH;
    private final String CH_COMMIT;

    static {
        new GlutenBuildInfo$();
    }

    private String buildFile() {
        return this.buildFile;
    }

    private InputStream buildFileStream() {
        return this.buildFileStream;
    }

    private String unknown() {
        return this.unknown;
    }

    private Properties props() {
        return this.props;
    }

    public String VERSION() {
        return this.VERSION;
    }

    public String GCC_VERSION() {
        return this.GCC_VERSION;
    }

    public String JAVA_COMPILE_VERSION() {
        return this.JAVA_COMPILE_VERSION;
    }

    public String SCALA_COMPILE_VERSION() {
        return this.SCALA_COMPILE_VERSION;
    }

    public String SPARK_COMPILE_VERSION() {
        return this.SPARK_COMPILE_VERSION;
    }

    public String HADOOP_COMPILE_VERSION() {
        return this.HADOOP_COMPILE_VERSION;
    }

    public String BRANCH() {
        return this.BRANCH;
    }

    public String REVISION() {
        return this.REVISION;
    }

    public String REVISION_TIME() {
        return this.REVISION_TIME;
    }

    public String BUILD_DATE() {
        return this.BUILD_DATE;
    }

    public String REPO_URL() {
        return this.REPO_URL;
    }

    public String VELOX_BRANCH() {
        return this.VELOX_BRANCH;
    }

    public String VELOX_REVISION() {
        return this.VELOX_REVISION;
    }

    public String VELOX_REVISION_TIME() {
        return this.VELOX_REVISION_TIME;
    }

    public String CH_BRANCH() {
        return this.CH_BRANCH;
    }

    public String CH_COMMIT() {
        return this.CH_COMMIT;
    }

    private GlutenBuildInfo$() {
        MODULE$ = this;
        this.buildFile = "gluten-build-info.properties";
        this.buildFileStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.buildFile());
        if (this.buildFileStream() == null) {
            throw new GlutenException(new StringBuilder(34).append("Can not load the core build file: ").append(this.buildFile()).toString());
        }
        this.unknown = "<unknown>";
        this.props = new Properties();
        try {
            this.props().load(this.buildFileStream());
        }
        finally {
            Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> MODULE$.buildFileStream().close());
        }
        this.VERSION = this.props().getProperty("gluten_version", this.unknown());
        this.GCC_VERSION = this.props().getProperty("gcc_version", this.unknown());
        this.JAVA_COMPILE_VERSION = this.props().getProperty("java_version", this.unknown());
        this.SCALA_COMPILE_VERSION = this.props().getProperty("scala_version", this.unknown());
        this.SPARK_COMPILE_VERSION = this.props().getProperty("spark_version", this.unknown());
        this.HADOOP_COMPILE_VERSION = this.props().getProperty("hadoop_version", this.unknown());
        this.BRANCH = this.props().getProperty("branch", this.unknown());
        this.REVISION = this.props().getProperty("revision", this.unknown());
        this.REVISION_TIME = this.props().getProperty("revision_time", this.unknown());
        this.BUILD_DATE = this.props().getProperty("date", this.unknown());
        this.REPO_URL = this.props().getProperty("url", this.unknown());
        this.VELOX_BRANCH = this.props().getProperty("velox_branch", this.unknown());
        this.VELOX_REVISION = this.props().getProperty("velox_revision", this.unknown());
        this.VELOX_REVISION_TIME = this.props().getProperty("velox_revision_time", this.unknown());
        this.CH_BRANCH = this.props().getProperty("ch_branch", this.unknown());
        this.CH_COMMIT = this.props().getProperty("ch_commit", this.unknown());
    }
}

