/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.gluten.memory.SimpleMemoryUsageRecorder;
import org.apache.spark.internal.Logging;
import org.apache.spark.task.TaskResource;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.mutable.SetLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015d\u0001\u0002\f\u0018\u0001\u0001BQ!\f\u0001\u0005\u00029Bq!\r\u0001C\u0002\u0013%!\u0007\u0003\u0004<\u0001\u0001\u0006Ia\r\u0005\by\u0001\u0011\r\u0011\"\u0003>\u0011\u0019!\u0006\u0001)A\u0005}!9Q\u000b\u0001b\u0001\n\u00131\u0006B\u00020\u0001A\u0003%q\u000bC\u0004`\u0001\u0001\u0007I\u0011\u00021\t\u000f\u0011\u0004\u0001\u0019!C\u0005K\"11\u000e\u0001Q!\n\u0005DQ\u0001\u001c\u0001\u0005\n5Daa \u0001\u0005\n\u0005\u0005\u0001bBA\u0007\u0001\u0011%\u0011q\u0002\u0005\b\u00033\u0001A\u0011BA\u000e\u0011!\ty\u0002\u0001C\u0001/\u0005\u0005\u0002\u0002CA\u0012\u0001\u0011\u0005q#!\n\t\u0011\u0005%\u0002\u0001\"\u0001\u0018\u0003WA\u0001\"!\u0011\u0001\t\u00039\u00121\t\u0005\t\u0003\u001f\u0002A\u0011A\f\u0002R!A\u0011Q\u000b\u0001\u0005\u0002]\t9\u0006\u0003\u0005\u0002b\u0001!\taFA2\u0005Q!\u0016m]6SKN|WO]2f%\u0016<\u0017n\u001d;ss*\u0011\u0001$G\u0001\u0005i\u0006\u001c8N\u0003\u0002\u001b7\u0005)1\u000f]1sW*\u0011A$H\u0001\u0007CB\f7\r[3\u000b\u0003y\t1a\u001c:h\u0007\u0001\u00192\u0001A\u0011(!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u0019\te.\u001f*fMB\u0011\u0001fK\u0007\u0002S)\u0011!&G\u0001\tS:$XM\u001d8bY&\u0011A&\u000b\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\tq\u0006\u0005\u00021\u00015\tq#A\u0006tQ\u0006\u0014X\rZ+tC\u001e,W#A\u001a\u0011\u0005QJT\"A\u001b\u000b\u0005Y:\u0014AB7f[>\u0014\u0018P\u0003\u000297\u00051q\r\\;uK:L!AO\u001b\u00033MKW\u000e\u001d7f\u001b\u0016lwN]=Vg\u0006<WMU3d_J$WM]\u0001\rg\"\f'/\u001a3Vg\u0006<W\rI\u0001\ne\u0016\u001cx.\u001e:dKN,\u0012A\u0010\t\u0005\u007f\u00113\u0015+D\u0001A\u0015\t\t%)\u0001\u0003vi&d'\"A\"\u0002\t)\fg/Y\u0005\u0003\u000b\u0002\u0013q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0002H\u001d:\u0011\u0001\n\u0014\t\u0003\u0013\u000ej\u0011A\u0013\u0006\u0003\u0017~\ta\u0001\u0010:p_Rt\u0014BA'$\u0003\u0019\u0001&/\u001a3fM&\u0011q\n\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u00055\u001b\u0003C\u0001\u0019S\u0013\t\u0019vC\u0001\u0007UCN\\'+Z:pkJ\u001cW-\u0001\u0006sKN|WO]2fg\u0002\n!\u0004\u001d:j_JLG/\u001f+p%\u0016\u001cx.\u001e:dKNl\u0015\r\u001d9j]\u001e,\u0012a\u0016\t\u0005\u007f\u0011C6\f\u0005\u0002#3&\u0011!l\t\u0002\u0004\u0013:$\bcA ]#&\u0011Q\f\u0011\u0002\u000e\u0019&t7.\u001a3ICND7+\u001a;\u00027A\u0014\u0018n\u001c:jif$vNU3t_V\u00148-Z:NCB\u0004\u0018N\\4!\u0003U)\u0007p\u00197vg&4X\rT8dW\u0006\u001b\u0017/^5sK\u0012,\u0012!\u0019\t\u0003E\tL!aY\u0012\u0003\u000f\t{w\u000e\\3b]\u0006IR\r_2mkNLg/\u001a'pG.\f5-];je\u0016$w\fJ3r)\t1\u0017\u000e\u0005\u0002#O&\u0011\u0001n\t\u0002\u0005+:LG\u000fC\u0004k\u0013\u0005\u0005\t\u0019A1\u0002\u0007a$\u0013'\u0001\ffq\u000edWo]5wK2{7m[!dcVL'/\u001a3!\u0003\u0011awnY6\u0016\u00059\fHCA8{!\t\u0001\u0018\u000f\u0004\u0001\u0005\u000bI\\!\u0019A:\u0003\u0003Q\u000b\"\u0001^<\u0011\u0005\t*\u0018B\u0001<$\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"A\t=\n\u0005e\u001c#aA!os\"11p\u0003CA\u0002q\fAAY8esB\u0019!%`8\n\u0005y\u001c#\u0001\u0003\u001fcs:\fW.\u001a \u0002\u001b\u0015D8\r\\;tSZ,Gj\\2l+\u0011\t\u0019!a\u0002\u0015\t\u0005\u0015\u0011\u0011\u0002\t\u0004a\u0006\u001dA!\u0002:\r\u0005\u0004\u0019\bbB>\r\t\u0003\u0007\u00111\u0002\t\u0005Eu\f)!\u0001\u0007bI\u0012\u0014Vm]8ve\u000e,\u0007\u0007F\u0003g\u0003#\t)\u0002\u0003\u0004\u0002\u00145\u0001\rAR\u0001\u0003S\u0012Da!a\u0006\u000e\u0001\u0004\t\u0016\u0001\u0003:fg>,(oY3\u0002\u000fI,G.Z1tKR\u0019a-!\b\t\r\u0005]a\u00021\u0001R\u0003)\u0011X\r\\3bg\u0016\fE\u000e\u001c\u000b\u0002M\u0006y!/\u001a7fCN,'+Z:pkJ\u001cW\rF\u0002g\u0003OAa!a\u0005\u0011\u0001\u00041\u0015AG1eIJ+7o\\;sG\u0016LeMT8u%\u0016<\u0017n\u001d;fe\u0016$W\u0003BA\u0017\u0003c!b!a\f\u00026\u0005]\u0002c\u00019\u00022\u00111!/\u0005b\u0001\u0003g\t\"\u0001^)\t\r\u0005M\u0011\u00031\u0001G\u0011\u001d\tI$\u0005a\u0001\u0003w\tqAZ1di>\u0014\u0018\u0010E\u0003#\u0003{\ty#C\u0002\u0002@\r\u0012\u0011BR;oGRLwN\u001c\u0019\u0002\u0017\u0005$GMU3t_V\u00148-Z\u000b\u0005\u0003\u000b\nI\u0005\u0006\u0004\u0002H\u0005-\u0013Q\n\t\u0004a\u0006%CA\u0002:\u0013\u0005\u0004\t\u0019\u0004\u0003\u0004\u0002\u0014I\u0001\rA\u0012\u0005\b\u0003/\u0011\u0002\u0019AA$\u0003QI7OU3t_V\u00148-\u001a*fO&\u001cH/\u001a:fIR\u0019\u0011-a\u0015\t\r\u0005M1\u00031\u0001G\u0003-9W\r\u001e*fg>,(oY3\u0016\t\u0005e\u0013Q\f\u000b\u0005\u00037\ny\u0006E\u0002q\u0003;\"aA\u001d\u000bC\u0002\u0005M\u0002BBA\n)\u0001\u0007a)\u0001\bhKR\u001c\u0006.\u0019:fIV\u001b\u0018mZ3\u0015\u0003M\u0002")
public class TaskResourceRegistry
implements Logging {
    private final SimpleMemoryUsageRecorder sharedUsage;
    private final HashMap<String, TaskResource> resources;
    private final HashMap<Object, LinkedHashSet<TaskResource>> priorityToResourcesMapping;
    private boolean exclusiveLockAcquired;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SimpleMemoryUsageRecorder sharedUsage() {
        return this.sharedUsage;
    }

    private HashMap<String, TaskResource> resources() {
        return this.resources;
    }

    private HashMap<Object, LinkedHashSet<TaskResource>> priorityToResourcesMapping() {
        return this.priorityToResourcesMapping;
    }

    private boolean exclusiveLockAcquired() {
        return this.exclusiveLockAcquired;
    }

    private void exclusiveLockAcquired_$eq(boolean x$1) {
        this.exclusiveLockAcquired = x$1;
    }

    private synchronized <T> T lock(Function0<T> body) {
        if (this.exclusiveLockAcquired()) {
            throw new ConcurrentModificationException();
        }
        return (T)body.apply();
    }

    private synchronized <T> T exclusiveLock(Function0<T> body) {
        Object object;
        if (this.exclusiveLockAcquired()) {
            throw new ConcurrentModificationException();
        }
        this.exclusiveLockAcquired_$eq(true);
        try {
            object = body.apply();
        }
        finally {
            this.exclusiveLockAcquired_$eq(false);
        }
        return (T)object;
    }

    private void addResource0(String id, TaskResource resource) {
        this.lock((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            this.resources().put(id, resource);
            return ((HashSet)this.priorityToResourcesMapping().computeIfAbsent(BoxesRunTime.boxToInteger((int)resource.priority()), x$1 -> TaskResourceRegistry.$anonfun$addResource0$2(BoxesRunTime.unboxToInt((Object)x$1)))).add(resource);
        });
    }

    private void release(TaskResource resource) {
        this.exclusiveLock((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> resource.release());
    }

    public void releaseAll() {
        this.lock((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ArrayList<Map.Entry<Object, LinkedHashSet<TaskResource>>> table = new ArrayList<Map.Entry<Object, LinkedHashSet<TaskResource>>>(this.priorityToResourcesMapping().entrySet());
            Collections.sort(table, (o1, o2) -> {
                int n;
                int diff = BoxesRunTime.unboxToInt(o2.getKey()) - BoxesRunTime.unboxToInt(o1.getKey());
                if (diff > 0) {
                    n = 1;
                } else if (diff < 0) {
                    n = -1;
                } else {
                    throw new IllegalStateException("Unreachable code from org.apache.spark.task.TaskResourceRegistry.releaseAll");
                }
                return n;
            });
            table.forEach((Consumer<Map.Entry<Object, LinkedHashSet<TaskResource>>>)((Consumer<Map.Entry>)x$2 -> ((IterableLike)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter((Set)x$2.getValue()).asScala()).toSeq().reverse()).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                this.release(x$3);
                return BoxedUnit.UNIT;
            })));
            this.priorityToResourcesMapping().clear();
            this.resources().clear();
        });
    }

    public void releaseResource(String id) {
        this.lock((Function0 & Serializable & scala.Serializable)() -> {
            if (!this.resources().containsKey(id)) {
                throw new IllegalArgumentException(String.format("TaskResource with ID %s is not registered", id));
            }
            TaskResource resource = this.resources().get(id);
            if (!this.priorityToResourcesMapping().containsKey(BoxesRunTime.boxToInteger((int)resource.priority()))) {
                throw new IllegalStateException("TaskResource's priority not found in priority mapping");
            }
            LinkedHashSet<TaskResource> samePrio = this.priorityToResourcesMapping().get(BoxesRunTime.boxToInteger((int)resource.priority()));
            if (!samePrio.contains(resource)) {
                throw new IllegalStateException("TaskResource not found in priority mapping");
            }
            this.release(resource);
            samePrio.remove(resource);
            return this.resources().remove(id);
        });
    }

    public <T extends TaskResource> T addResourceIfNotRegistered(String id, Function0<T> factory) {
        TaskResource taskResource;
        Object object = new Object();
        try {
            taskResource = (TaskResource)this.lock((Function0 & Serializable & scala.Serializable)() -> {
                if (this.resources().containsKey(id)) {
                    throw new NonLocalReturnControl(object, (Object)this.resources().get(id));
                }
                TaskResource resource = (TaskResource)factory.apply();
                this.addResource0(id, resource);
                return resource;
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                taskResource = (TaskResource)ex.value();
            }
            throw ex;
        }
        return (T)taskResource;
    }

    public <T extends TaskResource> T addResource(String id, T resource) {
        return (T)((TaskResource)this.lock((Function0 & Serializable & scala.Serializable)() -> {
            if (this.resources().containsKey(id)) {
                throw new IllegalArgumentException(String.format("TaskResource with ID %s is already registered", id));
            }
            this.addResource0(id, resource);
            return resource;
        }));
    }

    public boolean isResourceRegistered(String id) {
        return BoxesRunTime.unboxToBoolean(this.lock((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.resources().containsKey(id)));
    }

    public <T extends TaskResource> T getResource(String id) {
        return (T)((TaskResource)this.lock((Function0 & Serializable & scala.Serializable)() -> {
            if (!this.resources().containsKey(id)) {
                throw new IllegalArgumentException(String.format("TaskResource with ID %s is not registered", id));
            }
            return this.resources().get(id);
        }));
    }

    public SimpleMemoryUsageRecorder getSharedUsage() {
        return (SimpleMemoryUsageRecorder)this.lock((Function0 & Serializable & scala.Serializable)() -> this.sharedUsage());
    }

    public static final /* synthetic */ LinkedHashSet $anonfun$addResource0$2(int x$1) {
        return new LinkedHashSet();
    }

    public TaskResourceRegistry() {
        Logging.$init$((Logging)this);
        this.sharedUsage = new SimpleMemoryUsageRecorder();
        this.resources = new HashMap();
        this.priorityToResourcesMapping = new HashMap();
        this.exclusiveLockAcquired = false;
    }
}

