/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.circuitbreaker.resilience4j;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.reactor.circuitbreaker.operator.CircuitBreakerOperator;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import io.github.resilience4j.timelimiter.TimeLimiterRegistry;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.springframework.cloud.circuitbreaker.resilience4j.Resilience4JConfigBuilder;
import org.springframework.cloud.client.circuitbreaker.Customizer;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreaker;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveResilience4JCircuitBreaker
implements ReactiveCircuitBreaker {
    private final String id;
    private final CircuitBreakerConfig circuitBreakerConfig;
    private final CircuitBreakerRegistry circuitBreakerRegistry;
    private final TimeLimiterConfig timeLimiterConfig;
    private final TimeLimiterRegistry timeLimiterRegistry;
    private final Optional<Customizer<CircuitBreaker>> circuitBreakerCustomizer;

    @Deprecated
    public ReactiveResilience4JCircuitBreaker(String id, Resilience4JConfigBuilder.Resilience4JCircuitBreakerConfiguration config, CircuitBreakerRegistry circuitBreakerRegistry, Optional<Customizer<CircuitBreaker>> circuitBreakerCustomizer) {
        this.id = id;
        this.circuitBreakerConfig = config.getCircuitBreakerConfig();
        this.circuitBreakerRegistry = circuitBreakerRegistry;
        this.circuitBreakerCustomizer = circuitBreakerCustomizer;
        this.timeLimiterConfig = config.getTimeLimiterConfig();
        this.timeLimiterRegistry = TimeLimiterRegistry.ofDefaults();
    }

    public ReactiveResilience4JCircuitBreaker(String id, Resilience4JConfigBuilder.Resilience4JCircuitBreakerConfiguration config, CircuitBreakerRegistry circuitBreakerRegistry, TimeLimiterRegistry timeLimiterRegistry, Optional<Customizer<CircuitBreaker>> circuitBreakerCustomizer) {
        this.id = id;
        this.circuitBreakerConfig = config.getCircuitBreakerConfig();
        this.circuitBreakerRegistry = circuitBreakerRegistry;
        this.circuitBreakerCustomizer = circuitBreakerCustomizer;
        this.timeLimiterConfig = config.getTimeLimiterConfig();
        this.timeLimiterRegistry = timeLimiterRegistry;
    }

    public <T> Mono<T> run(Mono<T> toRun, Function<Throwable, Mono<T>> fallback) {
        CircuitBreaker defaultCircuitBreaker = this.circuitBreakerRegistry.circuitBreaker(this.id, this.circuitBreakerConfig);
        this.circuitBreakerCustomizer.ifPresent(customizer -> customizer.customize((Object)defaultCircuitBreaker));
        TimeLimiter timeLimiter = this.timeLimiterRegistry.timeLimiter(this.id, this.timeLimiterConfig);
        Mono toReturn = toRun.transform((Function)CircuitBreakerOperator.of((CircuitBreaker)defaultCircuitBreaker)).timeout(timeLimiter.getTimeLimiterConfig().getTimeoutDuration()).doOnError(TimeoutException.class, t -> defaultCircuitBreaker.onError(timeLimiter.getTimeLimiterConfig().getTimeoutDuration().toMillis(), TimeUnit.MILLISECONDS, (Throwable)t));
        if (fallback != null) {
            toReturn = toReturn.onErrorResume(fallback);
        }
        return toReturn;
    }

    public <T> Flux<T> run(Flux<T> toRun, Function<Throwable, Flux<T>> fallback) {
        CircuitBreaker defaultCircuitBreaker = this.circuitBreakerRegistry.circuitBreaker(this.id, this.circuitBreakerConfig);
        this.circuitBreakerCustomizer.ifPresent(customizer -> customizer.customize((Object)defaultCircuitBreaker));
        TimeLimiter timeLimiter = this.timeLimiterRegistry.timeLimiter(this.id, this.timeLimiterConfig);
        Flux toReturn = toRun.transform((Function)CircuitBreakerOperator.of((CircuitBreaker)defaultCircuitBreaker)).timeout(timeLimiter.getTimeLimiterConfig().getTimeoutDuration()).doOnError(TimeoutException.class, t -> defaultCircuitBreaker.onError(timeLimiter.getTimeLimiterConfig().getTimeoutDuration().toMillis(), TimeUnit.MILLISECONDS, (Throwable)t));
        if (fallback != null) {
            toReturn = toReturn.onErrorResume(fallback);
        }
        return toReturn;
    }
}

