/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.monitoring.endpoint;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.common.circuitbreaker.monitoring.endpoint.CircuitBreakerEndpointResponse;
import io.github.resilience4j.common.circuitbreaker.monitoring.endpoint.CircuitBreakerUpdateStateResponse;
import io.github.resilience4j.common.circuitbreaker.monitoring.endpoint.UpdateState;
import java.util.Arrays;
import java.util.List;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;

@Endpoint(id="circuitbreakers")
public class CircuitBreakerEndpoint {
    private final CircuitBreakerRegistry circuitBreakerRegistry;

    public CircuitBreakerEndpoint(CircuitBreakerRegistry circuitBreakerRegistry) {
        this.circuitBreakerRegistry = circuitBreakerRegistry;
    }

    @ReadOperation
    public CircuitBreakerEndpointResponse getAllCircuitBreakers() {
        List circuitBreakers = this.circuitBreakerRegistry.getAllCircuitBreakers().map(CircuitBreaker::getName).sorted().toJavaList();
        return new CircuitBreakerEndpointResponse(circuitBreakers);
    }

    @WriteOperation
    public CircuitBreakerUpdateStateResponse updateCircuitBreakerState(@Selector String name, UpdateState updateState) {
        CircuitBreaker circuitBreaker = this.circuitBreakerRegistry.circuitBreaker(name);
        String message = "%s state has been changed successfully";
        switch (updateState) {
            case CLOSE: {
                circuitBreaker.transitionToClosedState();
                return this.createCircuitBreakerUpdateStateResponse(name, circuitBreaker.getState().toString(), String.format("%s state has been changed successfully", name));
            }
            case FORCE_OPEN: {
                circuitBreaker.transitionToForcedOpenState();
                return this.createCircuitBreakerUpdateStateResponse(name, circuitBreaker.getState().toString(), String.format("%s state has been changed successfully", name));
            }
            case DISABLE: {
                circuitBreaker.transitionToDisabledState();
                return this.createCircuitBreakerUpdateStateResponse(name, circuitBreaker.getState().toString(), String.format("%s state has been changed successfully", name));
            }
        }
        return this.createCircuitBreakerUpdateStateResponse(name, circuitBreaker.getState().toString(), "State change value is not supported please use only " + Arrays.toString(UpdateState.values()));
    }

    private CircuitBreakerUpdateStateResponse createCircuitBreakerUpdateStateResponse(String circuitBreakerName, String newState, String message) {
        CircuitBreakerUpdateStateResponse circuitBreakerUpdateStateResponse = new CircuitBreakerUpdateStateResponse();
        circuitBreakerUpdateStateResponse.setCircuitBreakerName(circuitBreakerName);
        circuitBreakerUpdateStateResponse.setCurrentState(newState);
        circuitBreakerUpdateStateResponse.setMessage(message);
        return circuitBreakerUpdateStateResponse;
    }
}

