/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.operation;

import io.swagger.annotations.ResponseHeader;
import io.swagger.v3.oas.annotations.media.Schema;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.springframework.util.StringUtils;
import springfox.documentation.builders.ModelSpecificationBuilder;
import springfox.documentation.schema.CollectionType;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.ModelSpecification;
import springfox.documentation.schema.ScalarType;
import springfox.documentation.schema.ScalarTypes;
import springfox.documentation.schema.Types;
import springfox.documentation.schema.property.PackageNames;
import springfox.documentation.service.Header;

public class ResponseHeaders {
    private ResponseHeaders() {
        throw new UnsupportedOperationException();
    }

    public static Map<String, Header> headers(io.swagger.v3.oas.annotations.headers.Header[] responseHeaders) {
        HashMap<String, Header> headers = new HashMap<String, Header>();
        Stream.of(responseHeaders).filter(ResponseHeaders.emptyOrVoidHeader().negate()).forEachOrdered(each -> headers.put(each.name(), new Header(each.name(), each.description(), null, ResponseHeaders.headerModelSpecification(each), Boolean.valueOf(each.required()))));
        return headers;
    }

    public static Map<String, Header> headers(ResponseHeader[] responseHeaders) {
        return ResponseHeaders.headers(Arrays.asList(responseHeaders));
    }

    public static Map<String, Header> headers(Collection<ResponseHeader> responseHeaders) {
        HashMap<String, Header> headers = new HashMap<String, Header>();
        responseHeaders.stream().filter(ResponseHeaders.emptyOrVoid().negate()).forEachOrdered(each -> headers.put(each.name(), new Header(each.name(), each.description(), ResponseHeaders.headerModel(each), ResponseHeaders.headerSpecification(each))));
        return headers;
    }

    private static ModelSpecification headerSpecification(ResponseHeader each) {
        ModelSpecification itemSpecification = each.response() == Void.class || each.response() == Void.TYPE ? new ModelSpecificationBuilder().scalarModel(ScalarType.STRING).build() : (ScalarTypes.builtInScalarType((Type)each.response()).isPresent() ? new ModelSpecificationBuilder().scalarModel((ScalarType)ScalarTypes.builtInScalarType((Type)each.response()).get()).build() : new ModelSpecificationBuilder().referenceModel(r -> r.key(k -> k.qualifiedModelName(q -> q.namespace(PackageNames.safeGetPackageName((Class)each.response())).name(each.response().getSimpleName())))).build());
        if (ResponseHeaders.collectionTypeFromEnum(each.responseContainer()) == null) {
            new ModelSpecificationBuilder().collectionModel(c -> c.model(m -> m.copyOf(itemSpecification)).collectionType(ResponseHeaders.collectionTypeFromEnum(each.responseContainer()))).build();
        }
        return itemSpecification;
    }

    private static CollectionType collectionTypeFromEnum(String type) {
        if (Arrays.asList("LIST", "SET").contains(type.toUpperCase())) {
            return CollectionType.valueOf((String)type.toUpperCase());
        }
        return null;
    }

    private static Predicate<io.swagger.v3.oas.annotations.headers.Header> emptyOrVoidHeader() {
        return input -> StringUtils.isEmpty((Object)input.name()) || ResponseHeaders.isVoidImplementation(input) && StringUtils.isEmpty((Object)input.schema().type());
    }

    private static boolean isVoidImplementation(io.swagger.v3.oas.annotations.headers.Header input) {
        return !Void.class.equals((Object)input.schema().implementation()) && Void.TYPE.equals(input.schema().implementation());
    }

    private static Predicate<ResponseHeader> emptyOrVoid() {
        return input -> StringUtils.isEmpty((Object)input.name()) || Void.class.equals((Object)input.response());
    }

    private static ModelReference headerModel(ResponseHeader each) {
        String typeName = Optional.ofNullable(Types.typeNameFor((Type)each.response())).orElse("string");
        ModelRef modelReference = StringUtils.isEmpty((Object)each.responseContainer()) ? new ModelRef(typeName) : new ModelRef(each.responseContainer(), (ModelReference)new ModelRef(typeName));
        return modelReference;
    }

    private static ModelSpecification headerModelSpecification(io.swagger.v3.oas.annotations.headers.Header each) {
        Class type = each.schema().implementation();
        ModelSpecification itemSpecification = ResponseHeaders.emptyOrVoidHeader().test(each) ? new ModelSpecificationBuilder().scalarModel(ScalarType.STRING).facets(f -> f.deprecated(Boolean.valueOf(each.deprecated()))).build() : (ResponseHeaders.scalarType(each.schema()).isPresent() ? new ModelSpecificationBuilder().scalarModel(ResponseHeaders.scalarType(each.schema()).get()).facets(f -> f.deprecated(Boolean.valueOf(each.deprecated()))).build() : (ScalarTypes.builtInScalarType((Type)type).isPresent() ? new ModelSpecificationBuilder().scalarModel((ScalarType)ScalarTypes.builtInScalarType((Type)type).get()).facets(f -> f.deprecated(Boolean.valueOf(each.deprecated()))).build() : new ModelSpecificationBuilder().referenceModel(r -> r.key(k -> k.qualifiedModelName(q -> q.namespace(PackageNames.safeGetPackageName((Class)type)).name(type.getSimpleName())))).facets(f -> f.deprecated(Boolean.valueOf(each.deprecated()))).build()));
        if (each.schema().multipleOf() > 0.0) {
            return new ModelSpecificationBuilder().collectionModel(c -> c.model(m -> m.copyOf(itemSpecification)).collectionType(CollectionType.ARRAY)).facets(f -> f.deprecated(Boolean.valueOf(each.deprecated()))).build();
        }
        return itemSpecification;
    }

    private static Optional<ScalarType> scalarType(Schema schema) {
        if (StringUtils.isEmpty((Object)schema.type())) {
            return Optional.empty();
        }
        return ScalarType.from((String)schema.type(), (String)schema.format());
    }
}

