/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.datasource.storage;

import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.engine.spark.utils.StorageUtils$;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.physical.HashPartitioning;
import org.apache.spark.sql.datasource.storage.StorageStore;
import org.apache.spark.sql.datasource.storage.StorageStoreFactory$;
import org.apache.spark.sql.datasource.storage.UnsafelyInsertIntoHadoopFsRelationCommand;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.functions$;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class StorageStoreUtils$
implements Logging {
    public static StorageStoreUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new StorageStoreUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Set<String> writeSkewData(Seq<Object> bucketIds, Dataset<Row> dataFrame, Path outputPath, CatalogTable table, Seq<Column> normalCase, Seq<Column> skewCase, int bucketNum) {
        return (Set)this.withNoSkewDetectScope(dataFrame.sparkSession(), (Function0 & Serializable & scala.Serializable)() -> {
            List list;
            Configuration hadoopConf = dataFrame.sparkSession().sparkContext().hadoopConfiguration();
            FileSystem fs = outputPath.getFileSystem(hadoopConf);
            String outputPathStr = outputPath.toString();
            ExecutorService service = Executors.newCachedThreadPool();
            ExecutionContextExecutorService executorContext = ExecutionContext$.MODULE$.fromExecutorService(service);
            Seq futures = (Seq)((TraversableLike)((SeqLike)bucketIds.map((Function1 & Serializable & scala.Serializable)bucketId -> StorageStoreUtils$.$anonfun$writeSkewData$2(dataFrame, normalCase, bucketNum, skewCase, outputPathStr, BoxesRunTime.unboxToInt((Object)bucketId)), Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)new Tuple2((Object)dataFrame.filter(functions$.MODULE$.not(Column$.MODULE$.apply(new HashPartitioning((Seq)normalCase.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.expr(), Seq$.MODULE$.canBuildFrom()), bucketNum).partitionIdExpression()).isin(bucketIds))).repartition(bucketNum, normalCase), (Object)outputPath), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Dataset df = (Dataset)tuple2._1();
                Path path = (Path)tuple2._2();
                Future future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                    Tuple2 tuple2;
                    try {
                        Set<String> partitionDirs = MODULE$.writeBucketAndPartitionFile((Dataset<Row>)df, table, hadoopConf, path);
                        tuple2 = new Tuple2((Object)path, partitionDirs);
                    }
                    catch (Throwable t) {
                        MODULE$.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error for write skew data concurrently.", t);
                        throw t;
                    }
                    return tuple2;
                }, (ExecutionContext)executorContext);
                return future;
            }, Seq$.MODULE$.canBuildFrom());
            try {
                Future eventualFuture = Future$.MODULE$.sequence((TraversableOnce)futures.toList(), List$.MODULE$.canBuildFrom(), (ExecutionContext)executorContext);
                list = (List)ThreadUtils$.MODULE$.awaitResult((Awaitable)eventualFuture, (Duration)Duration$.MODULE$.Inf());
            }
            catch (Throwable t) {
                ThreadUtils$.MODULE$.shutdown(service, ThreadUtils$.MODULE$.shutdown$default$2());
                throw t;
            }
            List results = list;
            if (table.partitionColumnNames().isEmpty()) {
                ((List)((TraversableLike)results.map((Function1 & Serializable & scala.Serializable)x$4 -> (Path)x$4._1(), List$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)StorageStoreUtils$.$anonfun$writeSkewData$9(outputPathStr, x$5)))).foreach((Function1 & Serializable & scala.Serializable)path -> {
                    StorageStoreUtils$.$anonfun$writeSkewData$10(fs, outputPath, path);
                    return BoxedUnit.UNIT;
                });
            } else {
                MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("with partition column, results ").append(results).toString());
                ((List)results.filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)StorageStoreUtils$.$anonfun$writeSkewData$13(outputPathStr, x$6)))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    StorageStoreUtils$.$anonfun$writeSkewData$14(fs, outputPath, x0$2);
                    return BoxedUnit.UNIT;
                });
            }
            return ((TraversableOnce)results.flatMap((Function1 & Serializable & scala.Serializable)x$7 -> (Set)x$7._2(), List$.MODULE$.canBuildFrom())).toSet();
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple2<Seq<Column>, Seq<Column>> extractRepartitionColumns(CatalogTable table, LayoutEntity layout) {
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(table.bucketSpec().isDefined(), table.partitionColumnNames().nonEmpty());
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl2 = sp2._2$mcZ$sp();
            if (bl && bl2) {
                return new Tuple2(((BucketSpec)table.bucketSpec().get()).bucketColumnNames().map((Function1 & Serializable & scala.Serializable)colName -> functions$.MODULE$.col(colName), Seq$.MODULE$.canBuildFrom()), table.partitionColumnNames().map((Function1 & Serializable & scala.Serializable)colName -> functions$.MODULE$.col(colName), Seq$.MODULE$.canBuildFrom()));
            }
        }
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl3 = sp2._2$mcZ$sp();
            if (!bl && bl3) {
                return new Tuple2(table.partitionColumnNames().map((Function1 & Serializable & scala.Serializable)colName -> functions$.MODULE$.col(colName), Seq$.MODULE$.canBuildFrom()), ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)layout.getColOrder()).asScala()).map((Function1 & Serializable & scala.Serializable)id -> functions$.MODULE$.col(id.toString()), Buffer$.MODULE$.canBuildFrom()));
            }
        }
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl4 = sp2._2$mcZ$sp();
            if (bl && !bl4) {
                return new Tuple2(((BucketSpec)table.bucketSpec().get()).bucketColumnNames().map((Function1 & Serializable & scala.Serializable)colName -> functions$.MODULE$.col(colName), Seq$.MODULE$.canBuildFrom()), ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)layout.getColOrder()).asScala()).map((Function1 & Serializable & scala.Serializable)id -> functions$.MODULE$.col(id.toString()), Buffer$.MODULE$.canBuildFrom()));
            }
        }
        if (sp2 == null) throw new MatchError((Object)sp2);
        boolean bl = sp2._1$mcZ$sp();
        boolean bl5 = sp2._2$mcZ$sp();
        if (false != bl) throw new MatchError((Object)sp2);
        if (false != bl5) throw new MatchError((Object)sp2);
        return new Tuple2((Object)Nil$.MODULE$, (Object)Nil$.MODULE$);
    }

    private <U> U withNoSkewDetectScope(SparkSession ss, Function0<U> body) {
        Object object;
        try {
            ss.sessionState().conf().setLocalProperty("spark.sql.adaptive.shuffle.maxTargetPostShuffleInputSize", "-1");
            object = body.apply();
        }
        finally {
            ss.sessionState().conf().setLocalProperty("spark.sql.adaptive.shuffle.maxTargetPostShuffleInputSize", null);
        }
        return (U)object;
    }

    public Dataset<Row> toDF(NDataSegment segment, LayoutEntity layoutEntity, SparkSession sparkSession) {
        StorageStore qual$1 = StorageStoreFactory$.MODULE$.create(layoutEntity.getModel().getStorageType());
        NDataSegment x$1 = segment;
        LayoutEntity x$2 = layoutEntity;
        SparkSession x$3 = sparkSession;
        Map<String, String> x$4 = qual$1.readSpecialSegment$default$4();
        return qual$1.readSpecialSegment(x$1, x$2, x$3, x$4);
    }

    public Dataset<Row> toDF(NDataSegment segment, LayoutEntity layoutEntity, Long partitionId, SparkSession sparkSession) {
        return StorageStoreFactory$.MODULE$.create(layoutEntity.getModel().getStorageType()).readSpecialSegment(segment, layoutEntity, partitionId, sparkSession);
    }

    public Set<String> writeBucketAndPartitionFile(Dataset<Row> dataFrame, CatalogTable table, Configuration hadoopConf, Path qualifiedOutputPath) {
        dataFrame.sparkSession().sessionState().conf().setLocalProperty("spark.sql.adaptive.enabled.when.repartition", "true");
        ObjectRef partitionDirs = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        this.runCommand(dataFrame.sparkSession(), "UnsafelySave", new UnsafelyInsertIntoHadoopFsRelationCommand(qualifiedOutputPath, dataFrame.logicalPlan(), table, (Function1<Set<String>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)set -> {
            partitionDirs.elem = (Set)((Set)partitionDirs.elem).$plus$plus((GenTraversableOnce)set);
            return BoxedUnit.UNIT;
        }));
        dataFrame.sparkSession().sessionState().conf().setLocalProperty("spark.sql.adaptive.enabled.when.repartition", null);
        return (Set)partitionDirs.elem;
    }

    private void runCommand(SparkSession session, String name, LogicalPlan command) {
        QueryExecution qe = session.sessionState().executePlan(command, session.sessionState().executePlan$default$2());
    }

    public static final /* synthetic */ Tuple2 $anonfun$writeSkewData$2(Dataset dataFrame$1, Seq normalCase$1, int bucketNum$1, Seq skewCase$1, String outputPathStr$1, int bucketId) {
        return new Tuple2((Object)dataFrame$1.filter(Column$.MODULE$.apply(new HashPartitioning((Seq)normalCase$1.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.expr(), Seq$.MODULE$.canBuildFrom()), bucketNum$1).partitionIdExpression()).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)bucketId))).repartition(bucketNum$1, skewCase$1), (Object)new Path(new StringBuilder(6).append(outputPathStr$1).append("_temp_").append(bucketId).toString()));
    }

    public static final /* synthetic */ boolean $anonfun$writeSkewData$9(String outputPathStr$1, Path x$5) {
        return !x$5.toString().equals(outputPathStr$1);
    }

    public static final /* synthetic */ void $anonfun$writeSkewData$10(FileSystem fs$1, Path outputPath$1, Path path) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs$1.listStatus(path))).foreach((Function1 & Serializable & scala.Serializable)file -> {
            StorageUtils$.MODULE$.overwriteWithMessage(fs$1, file.getPath(), new Path(new StringBuilder(1).append(outputPath$1).append("/").append(file.getPath().getName()).toString()));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$writeSkewData$13(String outputPathStr$1, Tuple2 x$6) {
        return !((Path)x$6._1()).toString().equals(outputPathStr$1);
    }

    public static final /* synthetic */ void $anonfun$writeSkewData$15(FileSystem fs$1, Path outputPath$1, Path x2$1, String partition) {
        Object object = !fs$1.exists(new Path(new StringBuilder(1).append(outputPath$1).append("/").append(partition).toString())) ? BoxesRunTime.boxToBoolean((boolean)fs$1.mkdirs(new Path(new StringBuilder(1).append(outputPath$1).append("/").append(partition).toString()))) : BoxedUnit.UNIT;
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs$1.listStatus(new Path(new StringBuilder(1).append(x2$1).append("/").append(partition).toString())))).foreach((Function1 & Serializable & scala.Serializable)file -> {
            StorageUtils$.MODULE$.overwriteWithMessage(fs$1, file.getPath(), new Path(new StringBuilder(2).append(outputPath$1).append("/").append(partition).append("/").append(file.getPath().getName()).toString()));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$writeSkewData$14(FileSystem fs$1, Path outputPath$1, Tuple2 x0$2) {
        Path path;
        Set partitions;
        block3: {
            block2: {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) break block2;
                Path path2 = (Path)tuple2._1();
                partitions = (Set)tuple2._2();
                if (path2 == null) break block2;
                path = path2;
                if (partitions != null) break block3;
            }
            throw new RuntimeException();
        }
        Set set = partitions;
        set.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            StorageStoreUtils$.$anonfun$writeSkewData$15(fs$1, outputPath$1, path, partition);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private StorageStoreUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

