/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.utils;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.cube.model.DimensionRangeInfo;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.query.util.QueryInterruptChecker;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression$;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.execution.FileSourceScanExec;
import org.apache.spark.sql.execution.LayoutFileSourceScanExec;
import org.apache.spark.sql.execution.LeafExecNode;
import org.apache.spark.sql.execution.RowDataSourceScanExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.columnar.InMemoryTableScanExec;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.exchange.BroadcastExchangeLike;
import org.apache.spark.sql.execution.exchange.ReusedExchangeExec;
import org.apache.spark.sql.hive.HiveTableScanExecTransformer;
import org.apache.spark.sql.hive.execution.HiveTableScanExec;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.NBaseRelation;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.api.Mirror;
import scala.reflect.runtime.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

public final class ResourceDetectUtils$
implements Logging {
    public static ResourceDetectUtils$ MODULE$;
    private final Gson json;
    private final String errorMsgLog;
    private final String cubingDetectItemFileSuffix;
    private final String samplingDetectItemFileSuffix;
    private final String countDistinctSuffix;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ResourceDetectUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Gson json() {
        return this.json;
    }

    private String errorMsgLog() {
        return this.errorMsgLog;
    }

    public Seq<Path> getPaths(SparkPlan plan, boolean isResourceDetectJob) {
        ObjectRef paths = ObjectRef.create((Object)((Seq)Nil$.MODULE$));
        plan.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ResourceDetectUtils$.$anonfun$getPaths$1(paths, isResourceDetectJob, x0$1);
            return BoxedUnit.UNIT;
        });
        return (Seq)paths.elem;
    }

    public boolean getPaths$default$2() {
        return false;
    }

    public Seq<Path> getFilePaths(FileIndex fileIndex, Seq<Expression> partitionFilters, Seq<Expression> dataFilters, String info, boolean isResourceDetectJob) {
        ObjectRef paths = ObjectRef.create((Object)((Seq)Nil$.MODULE$));
        if (fileIndex.partitionSchema().nonEmpty()) {
            Seq newPartitionFilters = partitionFilters;
            if (isResourceDetectJob) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "The job is resource detect job, add filterNot of SubqueryExpression to the job.");
                newPartitionFilters = (Seq)partitionFilters.filterNot((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)SubqueryExpression$.MODULE$.hasSubquery(e)));
            }
            Seq selectedPartitions = fileIndex.listFiles(newPartitionFilters, dataFilters);
            ((IterableLike)selectedPartitions.flatMap((Function1 & Serializable & scala.Serializable)partition -> {
                QueryInterruptChecker.checkThreadInterrupted((String)MODULE$.errorMsgLog(), (String)info);
                return partition.files();
            }, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)file -> {
                paths.elem = (Seq)((Seq)paths.elem).$colon$plus((Object)file.getPath(), Seq$.MODULE$.canBuildFrom());
                return BoxedUnit.UNIT;
            });
        } else {
            paths.elem = (Seq)((Seq)paths.elem).$plus$plus((GenTraversableOnce)fileIndex.rootPaths(), Seq$.MODULE$.canBuildFrom());
        }
        return (Seq)paths.elem;
    }

    public boolean checkPartitionFilter(SparkPlan plan) {
        BooleanRef isIncludeFilter = BooleanRef.create((boolean)false);
        plan.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ResourceDetectUtils$.$anonfun$checkPartitionFilter$1(isIncludeFilter, x0$1);
            return BoxedUnit.UNIT;
        });
        return isIncludeFilter.elem;
    }

    public String getPartitions(SparkPlan plan) {
        None$ none$;
        scala.collection.mutable.Map leafNodePartitionsLengthMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        IntRef pNum = IntRef.create((int)0);
        try {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Try to find HiveTableScanExecTransformer class");
            ((Mirror)package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader())).staticClass("org.apache.spark.sql.hive.HiveTableScanExecTransformer");
            none$ = new Some(HiveTableScanExecTransformer.class);
        }
        catch (Exception exception) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "HiveTableScanExecTransformer class not found, skipping.");
            none$ = None$.MODULE$;
        }
        None$ hiveTableScanExecTransformerClass = none$;
        plan.foreach(arg_0 -> ResourceDetectUtils$.$anonfun$getPartitions$3$adapted((Option)hiveTableScanExecTransformerClass, leafNodePartitionsLengthMap, pNum, arg_0));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("Partition num ").append(pNum$1.elem).toString());
        return Integer.toString(pNum.elem);
    }

    /*
     * WARNING - void declaration
     */
    public java.util.Map<String, java.util.Map<String, Object>> listSourcePath(Path shareDir) throws IOException {
        void var3_3;
        block0: {
            FileSystem fs = HadoopUtil.getWorkingFileSystem();
            HashMap resourcePaths = Maps.newHashMap();
            if (!fs.exists(shareDir)) break block0;
            FileStatus[] fileStatuses = fs.listStatus(shareDir, new PathFilter(){

                public boolean accept(Path path) {
                    return path.toString().endsWith(ResourceDetectUtils$.MODULE$.fileName());
                }
            });
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileStatuses)).foreach((Function1 & Serializable & scala.Serializable)file -> {
                String fileName = file.getPath().getName();
                String segmentId = fileName.substring(0, fileName.indexOf(MODULE$.fileName()) - 1);
                java.util.Map map = (java.util.Map)MODULE$.readResourcePathsAs(file.getPath());
                return resourcePaths.put(segmentId, map);
            });
        }
        return var3_3;
    }

    public boolean findCountDistinctMeasure(Collection<LayoutEntity> layouts) {
        boolean bl;
        Object object = new Object();
        try {
            ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(layouts).asScala()).foreach((Function1 & Serializable & scala.Serializable)layoutEntity -> {
                ResourceDetectUtils$.$anonfun$findCountDistinctMeasure$1(object, layoutEntity);
                return BoxedUnit.UNIT;
            });
            bl = false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public long getResourceSize(KylinConfig kylinConfig, Configuration configuration, Seq<Path> paths) {
        long resourceSize = kylinConfig.isConcurrencyFetchDataSourceSize() ? this.getResourceSizeWithTimeoutByConcurrency(kylinConfig, (Duration)Duration$.MODULE$.Inf(), configuration, paths) : this.getResourceSizBySerial(kylinConfig, configuration, paths);
        return resourceSize;
    }

    public long getResourceSizBySerial(KylinConfig kylinConfig, Configuration configuration, Seq<Path> paths) {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)paths.map((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToLong((long)ResourceDetectUtils$.$anonfun$getResourceSizBySerial$1(configuration, kylinConfig, path)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public long getResourceSizeWithTimeoutByConcurrency(KylinConfig kylinConfig, Duration timeout, Configuration configuration, Seq<Path> paths) {
        long l;
        int threadNumber = kylinConfig.getConcurrencyFetchDataSourceSizeThreadNumber();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Get resource size concurrency, thread number is ").append(threadNumber).toString());
        ExecutorService executor = Executors.newFixedThreadPool(threadNumber);
        ExecutionContextExecutor executionContext = ExecutionContext$.MODULE$.fromExecutor((Executor)executor);
        Seq<Future<Object>> futures = this.getResourceSize(kylinConfig, configuration, executionContext, paths);
        try {
            Future combinedFuture = Future$.MODULE$.sequence(futures, Seq$.MODULE$.canBuildFrom(), (ExecutionContext)executionContext);
            Seq results = (Seq)ThreadUtils$.MODULE$.awaitResult((Awaitable)combinedFuture, timeout);
            l = BoxesRunTime.unboxToLong((Object)results.sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        }
        finally {
            executor.shutdownNow();
        }
        return l;
    }

    public Seq<Future<Object>> getResourceSize(KylinConfig kylinConfig, Configuration configuration, ExecutionContextExecutor executionContext, Seq<Path> paths) {
        return (Seq)paths.map((Function1 & Serializable & scala.Serializable)path -> Future$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> {
            FileSystem fs = path.getFileSystem(configuration);
            return fs.exists(path) ? HadoopUtil.getContentSummaryFromHdfsKylinConfig((FileSystem)fs, (Path)path, (KylinConfig)kylinConfig).getLength() : 0L;
        }, (ExecutionContext)executionContext), Seq$.MODULE$.canBuildFrom());
    }

    public long getResourceSize(KylinConfig kylinConfig, Seq<Path> paths) {
        return this.getResourceSize(kylinConfig, HadoopUtil.getCurrentConfiguration(), paths);
    }

    public long getMaxResourceSize(Path shareDir) {
        return (long)BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.listSourcePath(shareDir).values()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)value -> (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(value.values()).asScala(), Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$));
    }

    public java.util.Map<String, Object> getSegmentSourceSize(Path shareDir) {
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.listSourcePath(shareDir)).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ResourceDetectUtils$.$anonfun$getSegmentSourceSize$1(x$2)))).map((Function1 & Serializable & scala.Serializable)tp -> new Tuple2(tp._1(), (Object)BoxesRunTime.boxToLong((long)((long)BoxesRunTime.unboxToDouble(((java.util.Map)tp._2()).get("-1"))))), Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
    }

    public void write(Path path, Object item) {
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        try (FSDataOutputStream out = null;){
            out = fs.create(path);
            String str = this.json().toJson(item);
            byte[] bytes = str.getBytes(Charset.defaultCharset());
            out.writeInt(bytes.length);
            out.write(bytes);
        }
    }

    public String selectMaxValueInFiles(FileStatus[] files) {
        return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).map((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToDouble((double)ResourceDetectUtils$.$anonfun$selectMaxValueInFiles$1(f)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).max((Ordering)Ordering.Double$.MODULE$).toString();
    }

    public java.util.Map<String, String> readDetectItems(Path path) {
        return (java.util.Map)this.readResourcePathsAs(path);
    }

    public java.util.Map<String, DimensionRangeInfo> readSegDimRangeInfo(Path path) {
        return HadoopUtil.getWorkingFileSystem().exists(path) ? (java.util.Map)this.readResourcePathsAs(path) : null;
    }

    public <T> T readResourcePathsAs(Path path) {
        Object object;
        this.log().info(new StringBuilder(25).append("Read resource paths form ").append(path).toString());
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        try (FSDataInputStream in = null;){
            in = fs.open(path);
            int i = in.readInt();
            byte[] bytes = new byte[i];
            in.readFully(bytes);
            object = this.json().fromJson(new String(bytes, Charset.defaultCharset()), new TypeToken<T>(){}.getType());
        }
        return (T)object;
    }

    public String fileName() {
        return "resource_paths.json";
    }

    public String cubingDetectItemFileSuffix() {
        return this.cubingDetectItemFileSuffix;
    }

    public String samplingDetectItemFileSuffix() {
        return this.samplingDetectItemFileSuffix;
    }

    public String countDistinctSuffix() {
        return this.countDistinctSuffix;
    }

    public static final /* synthetic */ void $anonfun$getPaths$2(ObjectRef paths$1, Partition partition) {
        QueryInterruptChecker.checkThreadInterrupted((String)MODULE$.errorMsgLog(), (String)"Current step: get Partition file status of HiveTableScanExec.");
        paths$1.elem = (Seq)((Seq)paths$1.elem).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partition.getPath())), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$getPaths$1(ObjectRef paths$1, boolean isResourceDetectJob$1, SparkPlan x0$1) {
        SparkPlan sparkPlan = x0$1;
        if (sparkPlan instanceof FileSourceScanExec) {
            FileSourceScanExec fileSourceScanExec = (FileSourceScanExec)sparkPlan;
            String info = "Current step: get Partition file status of FileSourceScanExec.";
            paths$1.elem = (Seq)((Seq)paths$1.elem).$plus$plus(MODULE$.getFilePaths(fileSourceScanExec.relation().location(), (Seq<Expression>)fileSourceScanExec.partitionFilters(), (Seq<Expression>)fileSourceScanExec.dataFilters(), info, isResourceDetectJob$1), Seq$.MODULE$.canBuildFrom());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkPlan instanceof LayoutFileSourceScanExec) {
            LayoutFileSourceScanExec layoutFileSourceScanExec = (LayoutFileSourceScanExec)sparkPlan;
            String info = "Current step: get Partition file status of LayoutFileSourceScanExec.";
            paths$1.elem = (Seq)((Seq)paths$1.elem).$plus$plus(MODULE$.getFilePaths(layoutFileSourceScanExec.relation().location(), layoutFileSourceScanExec.partitionFilters(), layoutFileSourceScanExec.dataFilters(), info, isResourceDetectJob$1), Seq$.MODULE$.canBuildFrom());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkPlan instanceof InMemoryTableScanExec) {
            InMemoryTableScanExec inMemoryTableScanExec = (InMemoryTableScanExec)sparkPlan;
            SparkPlan _plan = inMemoryTableScanExec.relation().cachedPlan();
            paths$1.elem = (Seq)((Seq)paths$1.elem).$plus$plus(MODULE$.getPaths(_plan, MODULE$.getPaths$default$2()), Seq$.MODULE$.canBuildFrom());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkPlan instanceof HiveTableScanExec) {
            BoxedUnit boxedUnit;
            HiveTableScanExec hiveTableScanExec = (HiveTableScanExec)sparkPlan;
            if (hiveTableScanExec.relation().isPartitioned()) {
                hiveTableScanExec.rawPartitions().foreach((Function1 & Serializable & scala.Serializable)partition -> {
                    ResourceDetectUtils$.$anonfun$getPaths$2(paths$1, partition);
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                paths$1.elem = (Seq)((Seq)paths$1.elem).$colon$plus((Object)new Path(hiveTableScanExec.relation().tableMeta().location()), Seq$.MODULE$.canBuildFrom());
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (sparkPlan instanceof RowDataSourceScanExec) {
            RowDataSourceScanExec rowDataSourceScanExec = (RowDataSourceScanExec)sparkPlan;
            BaseRelation baseRelation = rowDataSourceScanExec.relation();
            if (baseRelation instanceof NBaseRelation) {
                NBaseRelation nBaseRelation = (NBaseRelation)baseRelation;
                paths$1.elem = (Seq)((Seq)paths$1.elem).$colon$plus((Object)nBaseRelation.location(), Seq$.MODULE$.canBuildFrom());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$checkPartitionFilter$1(BooleanRef isIncludeFilter$1, SparkPlan x0$1) {
        SparkPlan sparkPlan = x0$1;
        if (sparkPlan instanceof FileSourceScanExec) {
            FileSourceScanExec fileSourceScanExec = (FileSourceScanExec)sparkPlan;
            isIncludeFilter$1.elem = isIncludeFilter$1.elem || fileSourceScanExec.partitionFilters().nonEmpty();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkPlan instanceof LayoutFileSourceScanExec) {
            LayoutFileSourceScanExec layoutFileSourceScanExec = (LayoutFileSourceScanExec)sparkPlan;
            isIncludeFilter$1.elem = isIncludeFilter$1.elem || layoutFileSourceScanExec.partitionFilters().nonEmpty();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkPlan instanceof HiveTableScanExec) {
            BoxedUnit boxedUnit;
            HiveTableScanExec hiveTableScanExec = (HiveTableScanExec)sparkPlan;
            if (hiveTableScanExec.relation().isPartitioned()) {
                isIncludeFilter$1.elem = isIncludeFilter$1.elem || hiveTableScanExec.rawPartitions().nonEmpty();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$getPartitions$3(Option hiveTableScanExecTransformerClass$1, scala.collection.mutable.Map leafNodePartitionsLengthMap$1, IntRef pNum$1, SparkPlan x0$1) {
        SparkPlan sparkPlan = x0$1;
        if (sparkPlan instanceof LeafExecNode) {
            int n;
            ReusedExchangeExec reusedExchangeExec;
            LeafExecNode leafExecNode = (LeafExecNode)sparkPlan;
            LeafExecNode leafExecNode2 = leafExecNode;
            if (leafExecNode2 instanceof ReusedExchangeExec && (reusedExchangeExec = (ReusedExchangeExec)leafExecNode2).child() instanceof BroadcastExchangeLike) {
                n = 1;
            } else if (hiveTableScanExecTransformerClass$1.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isInstance(leafExecNode2)))) {
                HiveTableScanExecTransformer transformer = (HiveTableScanExecTransformer)leafExecNode2;
                n = transformer.getPartitions().length();
            } else {
                int partitionsLength = ((SparkPlan)leafExecNode).supportsColumnar() ? ((SparkPlan)leafExecNode).executeColumnar().partitions().length : ((SparkPlan)leafExecNode).execute().partitions().length;
                n = BoxesRunTime.unboxToInt((Object)leafNodePartitionsLengthMap$1.getOrElseUpdate((Object)((TreeNode)leafExecNode).nodeName(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> partitionsLength));
            }
            int pn = n;
            pNum$1.elem += pn;
            MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append(((TreeNode)leafExecNode).nodeName()).append(" partition size ").append(pn).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$findCountDistinctMeasure$2(Object nonLocalReturnKey1$1, NDataModel.Measure measure) {
        if (measure.getFunction().getExpression().equalsIgnoreCase("COUNT_DISTINCT")) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
        }
    }

    public static final /* synthetic */ void $anonfun$findCountDistinctMeasure$1(Object nonLocalReturnKey1$1, LayoutEntity layoutEntity) {
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter((Set)layoutEntity.getOrderedMeasures().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)measure -> {
            ResourceDetectUtils$.$anonfun$findCountDistinctMeasure$2(nonLocalReturnKey1$1, measure);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ long $anonfun$getResourceSizBySerial$1(Configuration configuration$1, KylinConfig kylinConfig$1, Path path) {
        QueryInterruptChecker.checkThreadInterrupted((String)MODULE$.errorMsgLog(), (String)"Current step: get resource size.");
        FileSystem fs = path.getFileSystem(configuration$1);
        return fs.exists(path) ? HadoopUtil.getContentSummaryFromHdfsKylinConfig((FileSystem)fs, (Path)path, (KylinConfig)kylinConfig$1).getLength() : 0L;
    }

    public static final /* synthetic */ boolean $anonfun$getSegmentSourceSize$1(Tuple2 x$2) {
        return ((java.util.Map)x$2._2()).keySet().contains("-1");
    }

    public static final /* synthetic */ double $anonfun$selectMaxValueInFiles$1(FileStatus f) {
        return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((java.util.Map)MODULE$.readResourcePathsAs(f.getPath())).values()).asScala()).max((Ordering)Ordering.Double$.MODULE$));
    }

    private ResourceDetectUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.json = new Gson();
        this.errorMsgLog = "Interrupted at the stage of get paths in ResourceDetectUtils.";
        this.cubingDetectItemFileSuffix = "cubing_detect_items.json";
        this.samplingDetectItemFileSuffix = "sampling_detect_items.json";
        this.countDistinctSuffix = "count_distinct.json";
    }

    public static final /* synthetic */ Object $anonfun$getPartitions$3$adapted(Option hiveTableScanExecTransformerClass$1, scala.collection.mutable.Map leafNodePartitionsLengthMap$1, IntRef pNum$1, SparkPlan x0$1) {
        ResourceDetectUtils$.$anonfun$getPartitions$3(hiveTableScanExecTransformerClass$1, leafNodePartitionsLengthMap$1, pNum$1, x0$1);
        return BoxedUnit.UNIT;
    }
}

