/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.execution;

import java.util.Iterator;
import org.apache.gluten.vectorized.CHColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;

public class ColumnarNativeIterator
implements Iterator<byte[]> {
    private final Iterator<ColumnarBatch> delegated;
    private transient ColumnarBatch nextBatch = null;

    public ColumnarNativeIterator(Iterator<ColumnarBatch> delegated) {
        this.delegated = delegated;
    }

    private static byte[] longtoBytes(long data) {
        return new byte[]{(byte)(data >> 56 & 0xFFL), (byte)(data >> 48 & 0xFFL), (byte)(data >> 40 & 0xFFL), (byte)(data >> 32 & 0xFFL), (byte)(data >> 24 & 0xFFL), (byte)(data >> 16 & 0xFFL), (byte)(data >> 8 & 0xFFL), (byte)(data >> 0 & 0xFFL)};
    }

    @Override
    public boolean hasNext() {
        while (this.delegated.hasNext()) {
            this.nextBatch = this.delegated.next();
            if (this.nextBatch.numRows() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte[] next() {
        if (this.nextBatch.numRows() > 0) {
            CHColumnVector col = (CHColumnVector)this.nextBatch.column(0);
            return ColumnarNativeIterator.longtoBytes(col.getBlockAddress());
        }
        throw new IllegalStateException();
    }
}

