/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.mergetree;

import java.net.URI;
import org.apache.spark.sql.delta.actions.Format;
import org.apache.spark.sql.delta.actions.Metadata;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;

public final class StorageMeta$ {
    public static StorageMeta$ MODULE$;
    private final String DEFAULT_PATH_BASED_DATABASE;
    private final String DEFAULT_CREATE_TABLE_DATABASE;
    private final String DEFAULT_ORDER_BY_KEY;
    private final String STORAGE_PREFIX;
    private final String DB;
    private final String TABLE;
    private final String SNAPSHOT_ID;
    private final String STORAGE_PATH;
    private final String POLICY;
    private final String ORDER_BY_KEY;
    private final String LOW_CARD_KEY;
    private final String MINMAX_INDEX_KEY;
    private final String BF_INDEX_KEY;
    private final String SET_INDEX_KEY;
    private final String PRIMARY_KEY;
    private final String SERIALIZER_HEADER;

    static {
        new StorageMeta$();
    }

    public String DEFAULT_PATH_BASED_DATABASE() {
        return this.DEFAULT_PATH_BASED_DATABASE;
    }

    public String DEFAULT_CREATE_TABLE_DATABASE() {
        return this.DEFAULT_CREATE_TABLE_DATABASE;
    }

    public String DEFAULT_ORDER_BY_KEY() {
        return this.DEFAULT_ORDER_BY_KEY;
    }

    public String STORAGE_PREFIX() {
        return this.STORAGE_PREFIX;
    }

    public String DB() {
        return this.DB;
    }

    public String TABLE() {
        return this.TABLE;
    }

    public String SNAPSHOT_ID() {
        return this.SNAPSHOT_ID;
    }

    public String STORAGE_PATH() {
        return this.STORAGE_PATH;
    }

    public String POLICY() {
        return this.POLICY;
    }

    public String ORDER_BY_KEY() {
        return this.ORDER_BY_KEY;
    }

    public String LOW_CARD_KEY() {
        return this.LOW_CARD_KEY;
    }

    public String MINMAX_INDEX_KEY() {
        return this.MINMAX_INDEX_KEY;
    }

    public String BF_INDEX_KEY() {
        return this.BF_INDEX_KEY;
    }

    public String SET_INDEX_KEY() {
        return this.SET_INDEX_KEY;
    }

    public String PRIMARY_KEY() {
        return this.PRIMARY_KEY;
    }

    public String SERIALIZER_HEADER() {
        return this.SERIALIZER_HEADER;
    }

    private String prefixOf(String key) {
        return new StringBuilder(0).append(this.STORAGE_PREFIX()).append(key).toString();
    }

    public Metadata withStorageID(Metadata metadata, String database, String tableName, String snapshotId) {
        Seq moreOptions = (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.DB()), (Object)database), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.SNAPSHOT_ID()), (Object)snapshotId), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TABLE()), (Object)tableName), (List)Nil$.MODULE$)));
        return this.withMoreOptions(metadata, (Seq<Tuple2<String, String>>)moreOptions);
    }

    private Metadata withMoreOptions(Metadata metadata, Seq<Tuple2<String, String>> newOptions) {
        Map x$1 = metadata.configuration().$plus$plus(newOptions);
        String x$2 = metadata.copy$default$1();
        String x$3 = metadata.copy$default$2();
        String x$4 = metadata.copy$default$3();
        Format x$5 = metadata.copy$default$4();
        String x$6 = metadata.copy$default$5();
        Seq x$7 = metadata.copy$default$6();
        Option x$8 = metadata.copy$default$8();
        return metadata.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$1, x$8);
    }

    public String normalizeRelativePath(String relativePath) {
        URI table_uri = URI.create(relativePath);
        return table_uri.getPath().startsWith("/") ? table_uri.getPath().substring(1) : table_uri.getPath();
    }

    private StorageMeta$() {
        MODULE$ = this;
        this.DEFAULT_PATH_BASED_DATABASE = "clickhouse_db";
        this.DEFAULT_CREATE_TABLE_DATABASE = "default";
        this.DEFAULT_ORDER_BY_KEY = "tuple()";
        this.STORAGE_PREFIX = "storage_";
        this.DB = this.prefixOf("db");
        this.TABLE = this.prefixOf("table");
        this.SNAPSHOT_ID = this.prefixOf("snapshot_id");
        this.STORAGE_PATH = this.prefixOf("path");
        this.POLICY = this.prefixOf("policy");
        this.ORDER_BY_KEY = this.prefixOf("orderByKey");
        this.LOW_CARD_KEY = this.prefixOf("lowCardKey");
        this.MINMAX_INDEX_KEY = this.prefixOf("minmaxIndexKey");
        this.BF_INDEX_KEY = this.prefixOf("bfIndexKey");
        this.SET_INDEX_KEY = this.prefixOf("setIndexKey");
        this.PRIMARY_KEY = this.prefixOf("primaryKey");
        this.SERIALIZER_HEADER = "MergeTree;";
    }
}

