/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import com.github.luben.zstd.ZstdOutputStreamNoFinalizer;
import com.ning.compress.lzf.LZFOutputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import net.jpountz.lz4.LZ4BlockOutputStream;
import org.apache.gluten.exception.GlutenException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xerial.snappy.SnappyOutputStream;

public final class CHShuffleWriteStreamFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CHShuffleWriteStreamFactory.class);
    public static final Field FIELD_SnappyOutputStream_out;
    public static final Field FIELD_LZ4BlockOutputStream_out;
    public static final Field FIELD_BufferedOutputStream_out;
    public static final Field FIELD_ZstdOutputStreamNoFinalizer_out;
    public static final Field FIELD_LZFOutputStream_out;

    private CHShuffleWriteStreamFactory() {
    }

    public static OutputStream unwrapSparkCompressionOutputStream(OutputStream os, boolean isCustomizedShuffleCodec) {
        if (!isCustomizedShuffleCodec) {
            return os;
        }
        OutputStream out = null;
        try {
            if (os instanceof BufferedOutputStream) {
                OutputStream cos = (OutputStream)FIELD_BufferedOutputStream_out.get(os);
                if (cos instanceof ZstdOutputStreamNoFinalizer) {
                    out = (OutputStream)FIELD_ZstdOutputStreamNoFinalizer_out.get(cos);
                }
            } else {
                if (os instanceof SnappyOutputStream) {
                    return null;
                }
                if (os instanceof LZ4BlockOutputStream) {
                    out = (OutputStream)FIELD_LZ4BlockOutputStream_out.get(os);
                } else if (os instanceof LZFOutputStream) {
                    out = (OutputStream)FIELD_LZFOutputStream_out.get(os);
                } else if (os instanceof ByteArrayOutputStream) {
                    out = os;
                }
            }
        }
        catch (IllegalAccessException e) {
            LOG.error("Can not get the field 'out' from compression output stream: ", (Throwable)e);
            return null;
        }
        return out;
    }

    static {
        try {
            FIELD_SnappyOutputStream_out = SnappyOutputStream.class.getDeclaredField("out");
            FIELD_SnappyOutputStream_out.setAccessible(true);
            FIELD_LZ4BlockOutputStream_out = LZ4BlockOutputStream.class.getSuperclass().getDeclaredField("out");
            FIELD_LZ4BlockOutputStream_out.setAccessible(true);
            FIELD_BufferedOutputStream_out = BufferedOutputStream.class.getSuperclass().getDeclaredField("out");
            FIELD_BufferedOutputStream_out.setAccessible(true);
            FIELD_ZstdOutputStreamNoFinalizer_out = ZstdOutputStreamNoFinalizer.class.getSuperclass().getDeclaredField("out");
            FIELD_ZstdOutputStreamNoFinalizer_out.setAccessible(true);
            FIELD_LZFOutputStream_out = LZFOutputStream.class.getSuperclass().getDeclaredField("out");
            FIELD_LZFOutputStream_out.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new GlutenException((Throwable)e);
        }
    }
}

