/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.persistence.transaction.LogicalViewBroadcastNotifier;
import org.apache.kylin.common.scheduler.EventBusFactory;
import org.apache.kylin.common.scheduler.SchedulerEventNotifier;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.view.LogicalView;
import org.apache.kylin.metadata.view.LogicalViewManager;
import org.apache.kylin.rest.ddl.SourceTableCheck;
import org.apache.kylin.rest.ddl.ViewCheck;
import org.apache.kylin.rest.request.ViewRequest;
import org.apache.kylin.rest.response.LogicalViewResponse;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.util.AclPermissionUtil;
import org.apache.spark.ddl.DDLCheck;
import org.apache.spark.ddl.DDLCheckContext;
import org.apache.spark.sql.LogicalViewLoader;
import org.apache.spark.sql.SparderEnv;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SparkDDLService
extends BasicService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SparkDDLService.class);
    private final List<DDLCheck> allChecks = Lists.newArrayList((Object[])new DDLCheck[]{new SourceTableCheck(), new ViewCheck()});

    public String executeSQL(ViewRequest request) {
        if (!KylinConfig.getInstanceFromEnv().isDDLEnabled()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.DDL_CHECK_ERROR, "DDL function has not been turned on.");
        }
        LogicalViewLoader.checkConfigIfNeed();
        Set groups = this.getCurrentUserGroups();
        DDLCheckContext context = new DDLCheckContext(request.getSql(), request.getDdlProject(), request.getRestrict(), AclPermissionUtil.getCurrentUsername(), groups, UserGroupInformation.isSecurityEnabled());
        List<DDLCheck> ddlCheckers = this.getFilterChecks(request.getDdlProject());
        Collections.sort(ddlCheckers);
        for (DDLCheck checker : ddlCheckers) {
            checker.check(context);
        }
        StringBuilder result = new StringBuilder();
        SparkSession session = SparderEnv.getSparkSession();
        String sql = LogicalViewLoader.addCatalog((String)request.getSql(), (String)context.getProject(), (SparkSession)session);
        List rows = session.sql(sql).collectAsList();
        rows.forEach(row -> result.append(row.get(0).toString()).append("\n"));
        if (context.isLogicalViewCommand()) {
            switch (context.getCommandType()) {
                case "replaceLogicalView": 
                case "createLogicalView": {
                    this.saveLogicalView(context);
                    break;
                }
                case "dropLogicalView": {
                    this.dropLogicalView(context);
                    break;
                }
            }
            EventBusFactory.getInstance().postAsync((SchedulerEventNotifier)new LogicalViewBroadcastNotifier());
        }
        return result.toString();
    }

    private List<DDLCheck> getFilterChecks(String project) {
        String skips = NProjectManager.getProjectConfig((String)project).getDDLCheckToSkip();
        return this.allChecks.stream().filter(check -> !skips.contains(check.getClass().getName())).collect(Collectors.toList());
    }

    public List<List<String>> pluginsDescription(String project, String pageType) {
        if (!KylinConfig.getInstanceFromEnv().isDDLEnabled()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.DDL_CHECK_ERROR, "DDL function has not been turned on.");
        }
        LogicalViewLoader.checkConfigIfNeed();
        ArrayList descriptionEN = Lists.newArrayList();
        ArrayList descriptionCN = Lists.newArrayList();
        List<DDLCheck> ddlCheckers = this.getFilterChecks(project);
        for (DDLCheck checker : ddlCheckers) {
            String[] description = checker.description(project, pageType);
            descriptionEN.addAll(Arrays.asList(description[0].split("\t")));
            descriptionCN.addAll(Arrays.asList(description[1].split("\t")));
        }
        return Lists.newArrayList((Object[])new List[]{descriptionEN, descriptionCN});
    }

    private void saveLogicalView(DDLCheckContext context) {
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            LogicalViewManager manager = LogicalViewManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
            LogicalView logicalView = new LogicalView(context.getLogicalViewName(), context.getLogicalViewPersistSql(), context.getUserName(), context.getProject());
            manager.update(logicalView);
            return null;
        }, (String)"_global");
        LogicalViewLoader.loadView((String)context.getLogicalViewName(), (boolean)false, (SparkSession)SparderEnv.getSparkSession());
    }

    private void dropLogicalView(DDLCheckContext context) {
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            LogicalViewManager manager = LogicalViewManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
            manager.delete(context.getLogicalViewName());
            return null;
        }, (String)"_global");
        LogicalViewLoader.unloadView((String)context.getLogicalViewName(), (SparkSession)SparderEnv.getSparkSession());
    }

    public List<LogicalViewResponse> listAll(String project, String tableName) {
        List logicalViews = LogicalViewManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).list();
        if (StringUtils.isNotBlank((CharSequence)tableName)) {
            logicalViews = logicalViews.stream().filter(table -> table.getTableName().toLowerCase(Locale.ROOT).contains(tableName.toLowerCase(Locale.ROOT))).collect(Collectors.toList());
        }
        ArrayList viewResponses = Lists.newArrayList();
        List viewResponsesInProject = logicalViews.stream().filter(table -> table.getCreatedProject().equalsIgnoreCase(project)).map(LogicalViewResponse::new).collect(Collectors.toList());
        List<LogicalViewResponse> viewResponsesNotInProject = logicalViews.stream().filter(table -> !table.getCreatedProject().equalsIgnoreCase(project)).map(LogicalViewResponse::new).collect(Collectors.toList());
        viewResponsesNotInProject.forEach(table -> table.setCreatedSql("***"));
        Collections.sort(viewResponsesInProject);
        Collections.sort(viewResponsesNotInProject);
        viewResponses.addAll(viewResponsesInProject);
        viewResponses.addAll(viewResponsesNotInProject);
        return viewResponses;
    }
}

