/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.exception.code.ErrorCodeSystem;
import org.apache.kylin.common.msg.Message;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.rest.BaseFilter;
import org.apache.kylin.rest.cluster.ClusterManager;
import org.apache.kylin.rest.interceptor.ProjectInfoParser;
import org.apache.kylin.rest.response.ErrorResponse;
import org.apache.kylin.rest.service.RouteService;
import org.glassfish.jersey.uri.UriTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.web.client.RestTemplate;

@Component
@Order(value=-2147483645)
public class QueryNodeFilter
extends BaseFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueryNodeFilter.class);
    private static Set<String> routeGetApiSet = Sets.newHashSet();
    private static Set<String> notRoutePostApiSet = Sets.newHashSet();
    private static Set<String> notRouteDeleteApiSet = Sets.newHashSet();
    private static Set<String> notRoutePutApiSet = Sets.newHashSet();
    private static Set<String> routeMultiTenantModeFilterApiSet = Sets.newHashSet();
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    ClusterManager clusterManager;
    @Autowired
    RouteService routeService;

    public void init(FilterConfig filterConfig) throws ServletException {
        log.info("init query request filter");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            String project;
            HttpServletRequest servletRequest = (HttpServletRequest)request;
            HttpServletResponse servletResponse = (HttpServletResponse)response;
            KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
            try {
                if (this.checkNeedToRoute(servletRequest)) {
                    chain.doFilter(request, response);
                    return;
                }
                if (CollectionUtils.isEmpty((Collection)this.clusterManager.getJobServers())) {
                    Message msg = MsgPicker.getMsg();
                    servletRequest.setAttribute("error", (Object)new KylinException((ErrorCodeSupplier)ServerErrorCode.NO_ACTIVE_ALL_NODE, msg.getNoActiveLeaders()));
                    servletRequest.getRequestDispatcher("/api/error").forward((ServletRequest)servletRequest, response);
                    return;
                }
                String contentType = request.getContentType();
                Pair projectInfo = ProjectInfoParser.parseProjectInfo((HttpServletRequest)servletRequest);
                project = (String)projectInfo.getFirst();
                if (!this.checkProjectExist(project)) {
                    servletRequest.setAttribute("error", (Object)new KylinException((ErrorCodeProducer)ErrorCodeServer.PROJECT_NOT_EXIST, new Object[]{project}));
                    servletRequest.getRequestDispatcher("/api/error").forward((ServletRequest)servletRequest, response);
                    return;
                }
                request = (ServletRequest)projectInfo.getSecond();
                if (this.checkServer(request, response, chain, kylinConfig, contentType)) {
                    return;
                }
                if (this.checkNeedToMultiTenantFilter(servletRequest)) {
                    chain.doFilter(request, response);
                    return;
                }
            }
            catch (CannotCreateTransactionException e) {
                this.writeConnectionErrorResponse(servletRequest, servletResponse);
                return;
            }
            log.debug("proxy {} {} to all", (Object)servletRequest.getMethod(), (Object)servletRequest.getRequestURI());
            this.routeAPI(this.restTemplate, request, (ServletResponse)servletResponse, project);
            return;
        }
        throw new KylinRuntimeException("unknown status");
    }

    private boolean checkServer(ServletRequest request, ServletResponse response, FilterChain chain, KylinConfig kylinConfig, String contentType) throws IOException, ServletException {
        if (this.checkProcessLocal(kylinConfig, contentType)) {
            log.info("process local caused by project owner");
            chain.doFilter(request, response);
            return true;
        }
        if (Boolean.FALSE.equals(kylinConfig.isQueryNodeRequestForwardEnabled()) && kylinConfig.isQueryNodeOnly()) {
            request.setAttribute("error", (Object)new KylinException((ErrorCodeProducer)ErrorCodeSystem.QUERY_NODE_API_INVALID, new Object[0]));
            request.getRequestDispatcher("/api/error").forward(request, response);
            return true;
        }
        return false;
    }

    public void destroy() {
    }

    private boolean checkNeedToRoute(HttpServletRequest servletRequest) {
        String uri = StringUtils.stripEnd((String)servletRequest.getRequestURI(), (String)"/");
        String method = servletRequest.getMethod();
        return !uri.startsWith("/kylin/api") || uri.startsWith("/kylin/api/error") || method.equals("GET") && !routeGetApiSet.contains(uri) || method.equals("POST") && notRoutePostApiSet.contains(uri) || method.equals("PUT") && notRoutePutApiSet.contains(uri) || method.equals("DELETE") && notRouteDeleteApiSet.contains(uri) || "true".equalsIgnoreCase(servletRequest.getHeader("routed")) || "true".equals(servletRequest.getAttribute("filter_pass")) || KylinConfig.getInstanceFromEnv().isUTEnv();
    }

    private boolean checkNeedToMultiTenantFilter(HttpServletRequest servletRequest) {
        String uri = StringUtils.stripEnd((String)servletRequest.getRequestURI(), (String)"/");
        String accept = servletRequest.getHeader("Accept");
        if (StringUtils.equals((CharSequence)accept, (CharSequence)"application/vnd.apache.kylin-v2+json") && this.routeService.needRoute()) {
            for (String needParserUrl : routeMultiTenantModeFilterApiSet) {
                HashMap kvMap;
                UriTemplate uriTemplate = new UriTemplate(needParserUrl);
                if (!uriTemplate.match((CharSequence)uri, kvMap = new HashMap())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkProcessLocal(KylinConfig kylinConfig, String contentType) {
        if (kylinConfig.isDevOrUT()) {
            return true;
        }
        if (kylinConfig.isQueryNodeOnly()) {
            return false;
        }
        return StringUtils.isEmpty((CharSequence)contentType) || !contentType.contains("multipart/form-data");
    }

    private boolean checkProjectExist(String project) {
        ProjectInstance prj;
        return "_global".equals(project) || (prj = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(project)) != null;
    }

    public void writeConnectionErrorResponse(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        ErrorResponse errorResponse = new ErrorResponse(servletRequest.getRequestURL().toString(), (Throwable)new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_CONNECT_CATALOG, MsgPicker.getMsg().getConnectDatabaseError(), false));
        byte[] responseBody = JsonUtil.writeValueAsBytes((Object)errorResponse);
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.APPLICATION_JSON);
        servletResponse.setStatus(500);
        this.setResponseHeaders(responseHeaders, servletResponse);
        servletResponse.getOutputStream().write(responseBody);
    }

    static {
        routeGetApiSet.add("/kylin/api/tables/reload_hive_table_name");
        routeGetApiSet.add("/kylin/api/tables/project_table_names");
        routeGetApiSet.add("/kylin/api/query/favorite_queries");
        notRoutePostApiSet.add("/kylin/api/query");
        notRoutePostApiSet.add("/kylin/api/async_query");
        notRoutePostApiSet.add("/kylin/api/query/if_big_query");
        notRoutePostApiSet.add("/kylin/api/query/prestate");
        notRoutePostApiSet.add("/kylin/api/user/authentication");
        notRoutePostApiSet.add("/kylin/api/system/maintenance_mode");
        notRouteDeleteApiSet.add("/kylin/api/query");
        notRouteDeleteApiSet.add("/kylin/api/query/if_big_query");
        notRoutePostApiSet.add("/kylin/api/kg/health/instance_info");
        notRoutePostApiSet.add("/kylin/api/kg/health/instance_service/query_up_grade");
        notRoutePostApiSet.add("/kylin/api/kg/health/instance_service/query_down_grade");
        notRoutePostApiSet.add("/kylin/api/system/license/content");
        notRoutePostApiSet.add("/kylin/api/system/license/file");
        notRoutePostApiSet.add("/kylin/api/system/diag");
        notRouteDeleteApiSet.add("/kylin/api/system/diag");
        notRouteDeleteApiSet.add("/kylin/api/system/maintenance_mode");
        notRoutePutApiSet.add("/kylin/api/system/diag/progress");
        notRoutePostApiSet.add("/kylin/api/metastore/backup/models");
        notRoutePostApiSet.add("/kylin/api/query/format/csv");
        notRoutePutApiSet.add("/kylin/api/tables/catalog_cache");
        notRoutePutApiSet.add("/kylin/api/tables/single_catalog_cache");
        notRoutePutApiSet.add("/kylin/api/index_plans/agg_index_count");
        notRoutePutApiSet.add("/kylin/api/system/roll_event_log");
        notRoutePostApiSet.add("/kylin/api/epoch");
        notRoutePostApiSet.add("/kylin/api/epoch/all");
        notRoutePostApiSet.add("/kylin/api/system/metadata/reload");
        routeGetApiSet.add("/kylin/api/storage/table/sync");
        notRoutePostApiSet.add("/kylin/api/storage/config/refresh");
        notRoutePostApiSet.add("/kylin/api/storage/node/status");
        notRoutePostApiSet.add("/kylin/api/snapshots/source_table_stats");
        notRoutePostApiSet.add("/kylin/api/snapshots/view_mapping");
        notRoutePutApiSet.add("/kylin/api/user/refresh");
        routeGetApiSet.add("/kylin/api/kafka/parsers");
        notRoutePostApiSet.add("/kylin/api/system/metadata_backup");
        notRoutePostApiSet.add("/kylin/api/system/broadcast_metadata_backup");
        notRoutePostApiSet.add("/kylin/api/metastore/cleanup_storage/tenant_node");
        notRoutePostApiSet.add("/kylin/api/metastore/cleanup_storage");
        notRouteDeleteApiSet.add("/kylin/api/system/clean_sparder_event_log");
        notRouteDeleteApiSet.add("/kylin/api/async_query/tenant_node");
        routeMultiTenantModeFilterApiSet.add("/kylin/api/jobs/{jobId}/resume");
        routeMultiTenantModeFilterApiSet.add("/kylin/api/cubes/{cubeName}/rebuild");
        routeMultiTenantModeFilterApiSet.add("/kylin/api/cubes/{cubeName}/segments");
        notRoutePutApiSet.add("/kylin/api/jobs/stage/status");
        notRoutePutApiSet.add("/kylin/api/jobs/spark");
        notRoutePutApiSet.add("/kylin/api/jobs/wait_and_run_time");
        notRoutePostApiSet.add("/kylin/api/jobs/gluten_cache");
        notRoutePostApiSet.add("/kylin/api/cache/gluten_cache");
        notRoutePostApiSet.add("/kylin/api/cache/gluten_cache_async");
    }
}

