/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.materialize;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.DataContexts;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.materialize.Lattice;
import org.apache.calcite.materialize.LatticeStatisticProvider;
import org.apache.calcite.materialize.MaterializationService;
import org.apache.calcite.profile.Profiler;
import org.apache.calcite.profile.ProfilerImpl;
import org.apache.calcite.rel.metadata.NullSentinel;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.MaterializedViewTable;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.kylin.guava30.shaded.common.base.Supplier;
import org.apache.kylin.guava30.shaded.common.base.Suppliers;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;

class ProfilerLatticeStatisticProvider
implements LatticeStatisticProvider {
    static final LatticeStatisticProvider.Factory FACTORY = ProfilerLatticeStatisticProvider::new;
    private final java.util.function.Supplier<Profiler.Profile> profile;

    private ProfilerLatticeStatisticProvider(Lattice lattice) {
        Objects.requireNonNull(lattice, "lattice");
        this.profile = () -> ((Supplier)Suppliers.memoize(() -> {
            ProfilerImpl profiler = ProfilerImpl.builder().withPassSize(200).withMinimumSurprise(0.3).build();
            ArrayList<Profiler.Column> columns = new ArrayList<Profiler.Column>();
            for (Lattice.Column column : lattice.columns) {
                columns.add(new Profiler.Column(column.ordinal, column.alias));
            }
            String sql = lattice.sql(ImmutableBitSet.range(lattice.columns.size()), false, (List<Lattice.Measure>)ImmutableList.of());
            Table table = new MaterializationService.DefaultTableFactory().createTable(lattice.rootSchema, sql, (List<String>)ImmutableList.of());
            ImmutableList initialGroups = ImmutableList.of();
            Enumerable rows = ((ScannableTable)table).scan(DataContexts.of(MaterializedViewTable.MATERIALIZATION_CONNECTION, lattice.rootSchema.plus())).select(values -> {
                for (int i = 0; i < ((Object[])values).length; ++i) {
                    if (values[i] != null) continue;
                    values[i] = NullSentinel.INSTANCE;
                }
                return Arrays.asList(values);
            });
            return profiler.profile((Iterable<List<Comparable>>)rows, columns, (Collection<ImmutableBitSet>)initialGroups);
        })).get();
    }

    @Override
    public double cardinality(List<Lattice.Column> columns) {
        ImmutableBitSet build = Lattice.Column.toBitSet(columns);
        double cardinality = this.profile.get().cardinality(build);
        return cardinality;
    }
}

