/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.mutable;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.mutable.MutableRel;
import org.apache.calcite.rel.mutable.MutableRelType;
import org.apache.calcite.rel.mutable.MutableRelVisitor;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;

abstract class MutableBiRel
extends MutableRel {
    protected MutableRel left;
    protected MutableRel right;

    protected MutableBiRel(MutableRelType type, RelOptCluster cluster, RelDataType rowType, MutableRel left, MutableRel right) {
        super(cluster, rowType, type);
        this.left = left;
        left.parent = this;
        left.ordinalInParent = 0;
        this.right = right;
        right.parent = this;
        right.ordinalInParent = 1;
    }

    @Override
    public void setInput(int ordinalInParent, MutableRel input) {
        if (ordinalInParent > 1) {
            throw new IllegalArgumentException();
        }
        if (ordinalInParent == 0) {
            this.left = input;
        } else {
            this.right = input;
        }
        if (input != null) {
            input.parent = this;
            input.ordinalInParent = ordinalInParent;
        }
    }

    @Override
    public List<MutableRel> getInputs() {
        return ImmutableList.of((Object)this.left, (Object)this.right);
    }

    public MutableRel getLeft() {
        return this.left;
    }

    public MutableRel getRight() {
        return this.right;
    }

    @Override
    public void childrenAccept(MutableRelVisitor visitor) {
        visitor.visit(this.left);
        visitor.visit(this.right);
    }
}

