/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rel.rules.ImmutableAggregateProjectMergeRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.Value;

@Value.Enclosing
public class AggregateProjectMergeRule
extends RelRule<Config>
implements TransformationRule {
    protected AggregateProjectMergeRule(Config config) {
        super(config);
    }

    @Deprecated
    public AggregateProjectMergeRule(Class<? extends Aggregate> aggregateClass, Class<? extends Project> projectClass, RelBuilderFactory relBuilderFactory) {
        this(((Config)CoreRules.AGGREGATE_PROJECT_MERGE.config).withRelBuilderFactory(relBuilderFactory).as(Config.class).withOperandFor(aggregateClass, projectClass));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Project project;
        Aggregate aggregate = (Aggregate)call.rel(0);
        RelNode x = AggregateProjectMergeRule.apply(call, aggregate, project = (Project)call.rel(1));
        if (x != null) {
            call.transformTo(x);
        }
    }

    public static @Nullable RelNode apply(RelOptRuleCall call, Aggregate aggregate, Project project) {
        Set<Integer> interestingFields = RelOptUtil.getAllFields(aggregate);
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (int source : interestingFields) {
            RexNode rex = project.getProjects().get(source);
            if (!(rex instanceof RexInputRef)) {
                return null;
            }
            map.put(source, ((RexInputRef)rex).getIndex());
        }
        ImmutableBitSet newGroupSet = aggregate.getGroupSet().permute(map);
        ImmutableList newGroupingSets = null;
        if (aggregate.getGroupType() != Aggregate.Group.SIMPLE) {
            newGroupingSets = ImmutableBitSet.ORDERING.immutableSortedCopy(ImmutableBitSet.permute(aggregate.getGroupSets(), map));
        }
        ImmutableList.Builder aggCalls = ImmutableList.builder();
        int sourceCount = aggregate.getInput().getRowType().getFieldCount();
        int targetCount = project.getInput().getRowType().getFieldCount();
        Mappings.TargetMapping targetMapping = Mappings.target(map, sourceCount, targetCount);
        for (AggregateCall aggregateCall : aggregate.getAggCallList()) {
            aggCalls.add((Object)aggregateCall.transform(targetMapping));
        }
        Aggregate newAggregate = aggregate.copy(aggregate.getTraitSet(), project.getInput(), newGroupSet, (List<ImmutableBitSet>)newGroupingSets, (List<AggregateCall>)aggCalls.build());
        RelBuilder relBuilder = call.builder();
        relBuilder.push(newAggregate);
        List<Integer> newKeys = Util.transform(aggregate.getGroupSet().asList(), key -> (Integer)Objects.requireNonNull(map.get(key), () -> "no value found for key " + key + " in " + map));
        if (!newKeys.equals(newGroupSet.asList())) {
            ArrayList<Integer> posList = new ArrayList<Integer>();
            for (int newKey : newKeys) {
                posList.add(newGroupSet.indexOf(newKey));
            }
            for (int i = newAggregate.getGroupCount(); i < newAggregate.getRowType().getFieldCount(); ++i) {
                posList.add(i);
            }
            relBuilder.project((Iterable<? extends RexNode>)relBuilder.fields((List<? extends Number>)posList));
        }
        return relBuilder.build();
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableAggregateProjectMergeRule.Config.of().withOperandFor(Aggregate.class, Project.class);

        @Override
        default public AggregateProjectMergeRule toRule() {
            return new AggregateProjectMergeRule(this);
        }

        default public Config withOperandFor(Class<? extends Aggregate> aggregateClass, Class<? extends Project> projectClass) {
            return this.withOperandSupplier(b0 -> b0.operand(aggregateClass).oneInput(b1 -> b1.operand(projectClass).anyInputs())).as(Config.class);
        }
    }
}

