/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.ddl;

import java.util.AbstractList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.sql.SqlCreate;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.calcite.util.Pair;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlCreateForeignSchema
extends SqlCreate {
    public final SqlIdentifier name;
    public final @Nullable SqlNode type;
    public final @Nullable SqlNode library;
    private final @Nullable SqlNodeList optionList;
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("CREATE FOREIGN SCHEMA", SqlKind.CREATE_FOREIGN_SCHEMA);

    SqlCreateForeignSchema(SqlParserPos pos, boolean replace, boolean ifNotExists, SqlIdentifier name, @Nullable SqlNode type, @Nullable SqlNode library, @Nullable SqlNodeList optionList) {
        super(OPERATOR, pos, replace, ifNotExists);
        this.name = Objects.requireNonNull(name, "name");
        this.type = type;
        this.library = library;
        Preconditions.checkArgument((type == null != (library == null) ? 1 : 0) != 0, (Object)"of type and library, exactly one must be specified");
        this.optionList = optionList;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.name, this.type, this.library, this.optionList);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        if (this.getReplace()) {
            writer.keyword("CREATE OR REPLACE");
        } else {
            writer.keyword("CREATE");
        }
        writer.keyword("FOREIGN SCHEMA");
        if (this.ifNotExists) {
            writer.keyword("IF NOT EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
        if (this.library != null) {
            writer.keyword("LIBRARY");
            this.library.unparse(writer, 0, 0);
        }
        if (this.type != null) {
            writer.keyword("TYPE");
            this.type.unparse(writer, 0, 0);
        }
        if (this.optionList != null) {
            writer.keyword("OPTIONS");
            SqlWriter.Frame frame = writer.startList("(", ")");
            int i = 0;
            for (Pair<SqlIdentifier, SqlNode> c : this.options()) {
                if (i++ > 0) {
                    writer.sep(",");
                }
                ((SqlIdentifier)c.left).unparse(writer, 0, 0);
                ((SqlNode)c.right).unparse(writer, 0, 0);
            }
            writer.endList(frame);
        }
    }

    public List<Pair<SqlIdentifier, SqlNode>> options() {
        return SqlCreateForeignSchema.options(this.optionList);
    }

    private static List<Pair<SqlIdentifier, SqlNode>> options(final @Nullable SqlNodeList optionList) {
        if (optionList == null) {
            return ImmutableList.of();
        }
        return new AbstractList<Pair<SqlIdentifier, SqlNode>>(){

            @Override
            public Pair<SqlIdentifier, SqlNode> get(int index) {
                return Pair.of((SqlIdentifier)Nullness.castNonNull((Object)optionList.get(index * 2)), Nullness.castNonNull((Object)optionList.get(index * 2 + 1)));
            }

            @Override
            public int size() {
                return optionList.size() / 2;
            }
        };
    }
}

