/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MatchReturnTypeInference
implements SqlReturnTypeInference {
    private final int start;
    private final List<SqlTypeName> typeNames;

    public MatchReturnTypeInference(int start, SqlTypeName ... typeNames) {
        this(start, (Iterable<SqlTypeName>)ImmutableList.copyOf((Object[])typeNames));
    }

    public MatchReturnTypeInference(int start, Iterable<SqlTypeName> typeNames) {
        Preconditions.checkArgument((start >= 0 ? 1 : 0) != 0);
        this.start = start;
        this.typeNames = ImmutableList.copyOf(typeNames);
        Preconditions.checkArgument((!this.typeNames.isEmpty() ? 1 : 0) != 0);
    }

    @Override
    public @Nullable RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        for (int i = this.start; i < opBinding.getOperandCount(); ++i) {
            RelDataType argType = opBinding.getOperandType(i);
            if (!SqlTypeUtil.isOfSameTypeName(this.typeNames, argType)) continue;
            return argType;
        }
        return null;
    }
}

