/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.io.Serializable;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.types.JavaHashes;

public class CharSequenceWrapper
implements CharSequence,
Serializable {
    private CharSequence wrapped;

    public static CharSequenceWrapper wrap(CharSequence seq) {
        return new CharSequenceWrapper(seq);
    }

    private CharSequenceWrapper(CharSequence wrapped) {
        this.wrapped = wrapped;
    }

    public CharSequenceWrapper set(CharSequence newWrapped) {
        this.wrapped = newWrapped;
        return this;
    }

    public CharSequence get() {
        return this.wrapped;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CharSequenceWrapper)) {
            return false;
        }
        CharSequenceWrapper that = (CharSequenceWrapper)other;
        return Comparators.charSequences().compare(this.wrapped, that.wrapped) == 0;
    }

    public int hashCode() {
        return JavaHashes.hashCode(this.wrapped);
    }

    @Override
    public int length() {
        return this.wrapped.length();
    }

    @Override
    public char charAt(int index) {
        return this.wrapped.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.wrapped.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.wrapped.toString();
    }
}

