/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.util.Locale;
import org.apache.kylin.common.KylinConfig;
import oshi.SystemInfo;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.util.FileUtil;

public final class SystemInfoCollector {
    private static final long KIBI = 1024L;
    private static final long MEBI = 0x100000L;
    private static final long GIBI = 0x40000000L;
    private static final long TEBI = 0x10000000000L;
    private static final long PEBI = 0x4000000000000L;
    private static final long EXBI = 0x1000000000000000L;
    public static final String CONTAINER_MEMORY_USAGE_IN_BYTES = "/sys/fs/cgroup/memory/memory.usage_in_bytes";
    public static final String CONTAINER_MEMORY_LIMIT_IN_BYTES = "/sys/fs/cgroup/memory/memory.limit_in_bytes";
    private static HardwareAbstractionLayer hal = null;

    private static void init() {
        SystemInfo si = new SystemInfo();
        hal = si.getHardware();
    }

    public static Integer getAvailableMemoryInfo() {
        if (KylinConfig.getInstanceFromEnv().isDevOrUT()) {
            return 6192;
        }
        long memAvailable = 0L;
        if (KylinConfig.getInstanceFromEnv().getMicroServiceMode() == null) {
            memAvailable = hal.getMemory().getAvailable();
        } else {
            long containerMemoryLimit = FileUtil.getLongFromFile((String)CONTAINER_MEMORY_LIMIT_IN_BYTES);
            long containerMemoryUsage = FileUtil.getLongFromFile((String)CONTAINER_MEMORY_USAGE_IN_BYTES);
            memAvailable = containerMemoryLimit == 0L || containerMemoryUsage == 0L ? hal.getMemory().getAvailable() : containerMemoryLimit - containerMemoryUsage;
        }
        return memAvailable % 0x100000L == 0L ? Integer.parseInt(String.format(Locale.ROOT, "%d", memAvailable / 0x100000L)) : Integer.parseInt(String.format(Locale.ROOT, "%.0f", (double)memAvailable / 1048576.0));
    }

    static {
        SystemInfoCollector.init();
    }
}

