/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.execution;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.TimeUtil;
import org.apache.kylin.job.dao.JobStatisticsManager;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultExecutable;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;

public class DefaultExecutableOnTable
extends DefaultExecutable {
    public DefaultExecutableOnTable() {
    }

    public DefaultExecutableOnTable(Object notSetId) {
        super(notSetId);
    }

    public String getTableIdentity() {
        return this.getParam("table");
    }

    @Override
    public String getTargetSubjectAlias() {
        return this.getTableIdentity();
    }

    @Override
    protected void afterUpdateOutput(String jobId) {
        AbstractExecutable job = DefaultExecutableOnTable.getExecutableManager(this.getProject()).getJob(jobId);
        long duration = job.getDuration();
        long endTime = job.getEndTime();
        long startOfDay = TimeUtil.getDayStart((long)endTime);
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            JobStatisticsManager.getInstance(KylinConfig.getInstanceFromEnv(), this.project).updateStatistics(startOfDay, duration, 0L, 0);
            return true;
        }, (String)this.project);
    }
}

