/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.agent.attach;

import com.taobao.arthas.agent.attach.AttachArthasClassloader;
import java.arthas.SpyAPI;
import java.io.File;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.bytebuddy.agent.ByteBuddyAgent;
import org.zeroturnaround.zip.ZipUtil;

public class ArthasAgent {
    private static final int TEMP_DIR_ATTEMPTS = 10000;
    private static final String ARTHAS_CORE_JAR = "arthas-core.jar";
    private static final String ARTHAS_BOOTSTRAP = "com.taobao.arthas.core.server.ArthasBootstrap";
    private static final String GET_INSTANCE = "getInstance";
    private static final String IS_BIND = "isBind";
    private String errorMessage;
    private Map<String, String> configMap = new HashMap<String, String>();
    private String arthasHome;
    private boolean slientInit;
    private Instrumentation instrumentation;

    public ArthasAgent() {
        this(null, null, false, null);
    }

    public ArthasAgent(Map<String, String> configMap) {
        this(configMap, null, false, null);
    }

    public ArthasAgent(String arthasHome) {
        this(null, arthasHome, false, null);
    }

    public ArthasAgent(Map<String, String> configMap, String arthasHome, boolean slientInit, Instrumentation instrumentation) {
        if (configMap != null) {
            this.configMap = configMap;
        }
        this.arthasHome = arthasHome;
        this.slientInit = slientInit;
        this.instrumentation = instrumentation;
    }

    public static void attach() {
        new ArthasAgent().init();
    }

    public static void attach(Map<String, String> configMap) {
        new ArthasAgent(configMap).init();
    }

    public static void attach(String arthasHome) {
        new ArthasAgent().init();
    }

    public void init() throws IllegalStateException {
        block11: {
            try {
                Class.forName("java.arthas.SpyAPI");
                if (SpyAPI.isInited()) {
                    return;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                File arthasCoreJarFile;
                if (this.instrumentation == null) {
                    this.instrumentation = ByteBuddyAgent.install();
                }
                if (this.arthasHome == null || this.arthasHome.trim().isEmpty()) {
                    URL coreJarUrl = this.getClass().getClassLoader().getResource("arthas-bin.zip");
                    if (coreJarUrl != null) {
                        File tempArthasDir = ArthasAgent.createTempDir();
                        ZipUtil.unpack((InputStream)coreJarUrl.openStream(), (File)tempArthasDir);
                        this.arthasHome = tempArthasDir.getAbsolutePath();
                    } else {
                        throw new IllegalArgumentException("can not getResources arthas-bin.zip from classloader: " + this.getClass().getClassLoader());
                    }
                }
                if (!(arthasCoreJarFile = new File(this.arthasHome, ARTHAS_CORE_JAR)).exists()) {
                    throw new IllegalStateException("can not find arthas-core.jar under arthasHome: " + this.arthasHome);
                }
                AttachArthasClassloader arthasClassLoader = new AttachArthasClassloader(new URL[]{arthasCoreJarFile.toURI().toURL()});
                Class<?> bootstrapClass = arthasClassLoader.loadClass(ARTHAS_BOOTSTRAP);
                Object bootstrap = bootstrapClass.getMethod(GET_INSTANCE, Instrumentation.class, Map.class).invoke(null, this.instrumentation, this.configMap);
                boolean isBind = (Boolean)bootstrapClass.getMethod(IS_BIND, new Class[0]).invoke(bootstrap, new Object[0]);
                if (!isBind) {
                    String errorMsg = "Arthas server port binding failed! Please check $HOME/logs/arthas/arthas.log for more details.";
                    throw new RuntimeException(errorMsg);
                }
            }
            catch (Throwable e) {
                this.errorMessage = e.getMessage();
                if (this.slientInit) break block11;
                throw new IllegalStateException(e);
            }
        }
    }

    private static File createTempDir() {
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        String baseName = "arthas-" + System.currentTimeMillis() + "-";
        for (int counter = 0; counter < 10000; ++counter) {
            File tempDir = new File(baseDir, baseName + counter);
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new IllegalStateException("Failed to create directory within 10000 attempts (tried " + baseName + "0 to " + baseName + 9999 + ')');
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

