/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.remote;

import java.util.HashMap;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.calcite.avatica.remote.KerberosConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientKeytabJaasConf
extends Configuration {
    private static final Logger LOG = LoggerFactory.getLogger(ClientKeytabJaasConf.class);
    private final String principal;
    private final String keytab;

    public ClientKeytabJaasConf(String principal, String keytab) {
        this.principal = principal;
        this.keytab = keytab;
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("principal", this.principal);
        options.put("refreshKrb5Config", "true");
        if (KerberosConnection.isIbmJava()) {
            options.put("useKeytab", this.keytab);
            options.put("credsType", "both");
        } else {
            options.put("keyTab", this.keytab);
            options.put("useKeyTab", "true");
            options.put("isInitiator", "true");
            options.put("doNotPrompt", "true");
            options.put("storeKey", "true");
        }
        LOG.debug("JAAS Configuration for client keytab-based Kerberos login: {}", options);
        return new AppConfigurationEntry[]{new AppConfigurationEntry(KerberosConnection.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
    }
}

