/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.SnappyCodec;
import org.apache.hadoop.util.NativeCodeLoader;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.Singletons;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.guava30.shaded.common.collect.ArrayListMultimap;
import org.apache.kylin.guava30.shaded.common.collect.ListMultimap;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.query.QueryHistory;
import org.apache.kylin.metadata.recommendation.candidate.RawRecItem;
import org.apache.kylin.metadata.recommendation.entity.LayoutRecItemV2;
import org.apache.kylin.rec.AbstractContext;
import org.apache.kylin.rec.common.AccelerateInfo;
import org.apache.kylin.rec.util.QueryRecItem;
import org.apache.logging.log4j.status.StatusLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryRecStatsCollector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueryRecStatsCollector.class);
    private static final String STORE_POSITION = "/query_rec/history/";
    private static final String TMP_STORE_POSITION = "/query_rec/tmp/";
    private static final String FILE_SUFFIX_SNAPPY = ".json.snappy";
    private static final String FILE_SUFFIX = ".json";

    public static QueryRecStatsCollector getInstance() {
        return (QueryRecStatsCollector)Singletons.getInstance(QueryRecStatsCollector.class);
    }

    private static String getRandomFileSuffix() {
        return "_" + RandomUtil.randomUUIDStr();
    }

    public void doStatistics(ListMultimap<String, QueryHistory> sqlToQueryHistoryMap, Map<String, RawRecItem> uniqueIdToLayoutRecMap, AbstractContext semiContext) {
        ArrayListMultimap sqlToQueryRecItemMap = ArrayListMultimap.create();
        sqlToQueryHistoryMap.forEach((arg_0, arg_1) -> QueryRecStatsCollector.lambda$doStatistics$0((ListMultimap)sqlToQueryRecItemMap, arg_0, arg_1));
        HashMap nonLayoutIdToRecMap = new HashMap();
        semiContext.getExistingNonLayoutRecItemMap().forEach((content, rec) -> {
            String recId = "-" + rec.getId();
            nonLayoutIdToRecMap.put(recId, rec);
        });
        semiContext.getAccelerateInfoMap().forEach((arg_0, arg_1) -> this.lambda$doStatistics$3((ListMultimap)sqlToQueryRecItemMap, uniqueIdToLayoutRecMap, semiContext, nonLayoutIdToRecMap, arg_0, arg_1));
        this.saveAll(sqlToQueryRecItemMap.values());
    }

    private void addLayoutInfo(List<QueryRecItem> queryRecItems, AbstractContext semiContext, AccelerateInfo.QueryLayoutRelation layoutRelation) {
        IndexPlan indexPlan = semiContext.getOriginIndexPlan(layoutRelation.getModelId());
        if (indexPlan == null) {
            log.error("[UNLIKELY_THINGS_HAPPENED] Reusing an existing layout on the missing model({})", (Object)layoutRelation.getModelId());
            return;
        }
        LayoutEntity layout = indexPlan.getLayoutEntity(Long.valueOf(layoutRelation.getLayoutId()));
        for (QueryRecItem queryRecItem : queryRecItems) {
            queryRecItem.addLayout(layout, indexPlan.getModel());
        }
    }

    private void addLayoutRecInfo(List<QueryRecItem> queryRecItems, AbstractContext semiContext, AccelerateInfo.QueryLayoutRelation layoutRelation, Map<String, RawRecItem> nonLayoutRecItemIdMap, RawRecItem layoutRecItem) {
        NDataModel model = semiContext.getProposedModel(layoutRelation.getModelId());
        if (model == null) {
            log.error("[UNLIKELY_THINGS_HAPPENED] Reusing an existing layout on the missing model({})", (Object)layoutRelation.getModelId());
            return;
        }
        LayoutEntity layout = ((LayoutRecItemV2)layoutRecItem.getRecEntity()).getLayout();
        for (QueryRecItem queryRecItem : queryRecItems) {
            queryRecItem.addLayoutRec(layout, model, nonLayoutRecItemIdMap);
        }
    }

    private void saveAll(Collection<QueryRecItem> queryRecItems) {
        if (CollectionUtils.isEmpty(queryRecItems)) {
            return;
        }
        List<QueryRecItem> sortedQueryRecItems = this.sortByQueryTime(queryRecItems);
        String day = sortedQueryRecItems.get(0).getDay();
        ArrayList<QueryRecItem> dailyHistory = new ArrayList<QueryRecItem>();
        for (QueryRecItem queryRecItem : sortedQueryRecItems) {
            if (day.equals(queryRecItem.getDay())) {
                dailyHistory.add(queryRecItem);
                continue;
            }
            this.saveDaily(dailyHistory);
            dailyHistory = new ArrayList();
            dailyHistory.add(queryRecItem);
            day = queryRecItem.getDay();
        }
        this.saveDaily(dailyHistory);
    }

    private List<QueryRecItem> sortByQueryTime(Collection<QueryRecItem> queryHistoryForAnalyses) {
        return queryHistoryForAnalyses.stream().sorted((o1, o2) -> {
            if (o1.getQueryTime() - o2.getQueryTime() == 0L) {
                return 0;
            }
            return o1.getQueryTime() - o2.getQueryTime() > 0L ? 1 : -1;
        }).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDaily(Collection<QueryRecItem> queryHistoryForAnalyses) {
        if (CollectionUtils.isEmpty(queryHistoryForAnalyses)) {
            return;
        }
        String project = queryHistoryForAnalyses.iterator().next().getProject();
        String day = queryHistoryForAnalyses.iterator().next().getDay();
        String tmpPath = project + TMP_STORE_POSITION + "query_history_" + System.currentTimeMillis() + QueryRecStatsCollector.getRandomFileSuffix();
        String destPath = project + STORE_POSITION + day + "/query_history_" + System.currentTimeMillis() + QueryRecStatsCollector.getRandomFileSuffix();
        try {
            OutputStreamWriter writer = QueryHistoryFStreamFactory.getInstance().getOutputStreamWriter(tmpPath, true);
            for (QueryRecItem queryRecItem : queryHistoryForAnalyses) {
                String queryHistoryStr = JsonUtil.writeValueAsString((Object)queryRecItem).replaceAll("[\n\r]", " ");
                writer.append(queryHistoryStr);
                writer.append(System.lineSeparator());
            }
            IOUtils.closeStream((Closeable)writer);
            QueryHistoryFStreamFactory.getInstance().rename(tmpPath, destPath, true);
        }
        catch (IOException e) {
            log.error("export daily history fail due to ", (Throwable)e);
        }
        finally {
            QueryHistoryFStreamFactory.getInstance().deleteFileIfExists(tmpPath, true);
        }
    }

    private /* synthetic */ void lambda$doStatistics$3(ListMultimap sqlToQueryRecItemMap, Map uniqueIdToLayoutRecMap, AbstractContext semiContext, Map nonLayoutIdToRecMap, String sql, AccelerateInfo accelerateInfo) {
        for (AccelerateInfo.QueryLayoutRelation relation : accelerateInfo.getRelatedLayouts()) {
            List queryRecItems = sqlToQueryRecItemMap.get((Object)sql);
            if (accelerateInfo.isNotSucceed()) {
                queryRecItems.forEach(queryRecItem -> {
                    queryRecItem.setAccelerated(false);
                    String failedReason = accelerateInfo.isFailed() ? accelerateInfo.getFailedCause().getMessage() : accelerateInfo.getPendingMsg();
                    queryRecItem.setAccFailedReason(failedReason);
                });
                continue;
            }
            RawRecItem layoutRec = (RawRecItem)uniqueIdToLayoutRecMap.get(relation.getUniqueId());
            if (layoutRec == null) {
                this.addLayoutInfo(queryRecItems, semiContext, relation);
                continue;
            }
            this.addLayoutRecInfo(queryRecItems, semiContext, relation, nonLayoutIdToRecMap, layoutRec);
        }
    }

    private static /* synthetic */ void lambda$doStatistics$0(ListMultimap sqlToQueryRecItemMap, String sql, QueryHistory queryHistory) {
        QueryRecItem queryRecItem = new QueryRecItem(queryHistory);
        sqlToQueryRecItemMap.put((Object)sql, (Object)queryRecItem);
    }

    public static class QueryHistoryFStreamFactory {
        private final FileSystem fileSystem;
        private final String workingDir;
        private CompressionCodec codec = null;

        private QueryHistoryFStreamFactory() {
            try {
                this.workingDir = KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory().endsWith("/") ? KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory() : KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory() + "/";
                this.fileSystem = FileSystem.newInstance((URI)new Path(this.workingDir).toUri(), (Configuration)new Configuration());
                this.initSnappyCodec();
            }
            catch (IOException e) {
                StatusLogger.getLogger().error("Failed to create the file system, ", (Throwable)e);
                throw new KylinRuntimeException("Failed to create the file system, ", (Throwable)e);
            }
        }

        public static QueryHistoryFStreamFactory getInstance() {
            return (QueryHistoryFStreamFactory)Singletons.getInstance(QueryHistoryFStreamFactory.class);
        }

        private void initSnappyCodec() {
            try {
                NativeCodeLoader.buildSupportsSnappy();
                this.codec = (CompressionCodec)ReflectionUtils.newInstance(SnappyCodec.class, (Configuration)new Configuration());
            }
            catch (UnsatisfiedLinkError e) {
                log.warn("snappy not support under this environment, disable snappy codec");
            }
        }

        public OutputStreamWriter getOutputStreamWriter(String path, boolean usingSnappy) throws IOException {
            OutputStream outputStream = this.getOutputStream(path, usingSnappy);
            return new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
        }

        private OutputStream getOutputStream(String path, boolean usingSnappy) throws IOException {
            FSDataOutputStream outputStream;
            Path fsPath = this.getFullPath(path, usingSnappy);
            FSDataOutputStream fSDataOutputStream = outputStream = this.fileSystem.exists(fsPath) ? this.fileSystem.append(fsPath) : this.fileSystem.create(fsPath, true);
            if (usingSnappy && this.codec != null) {
                return this.codec.createOutputStream((OutputStream)outputStream);
            }
            return outputStream;
        }

        public void rename(String path, String destPath, boolean usingSnappy) throws IOException {
            Path source = this.getFullPath(path, usingSnappy);
            Path target = this.getFullPath(destPath, usingSnappy);
            if (this.fileSystem.exists(source)) {
                if (!this.fileSystem.exists(target.getParent())) {
                    this.fileSystem.mkdirs(target.getParent());
                }
                this.fileSystem.rename(source, target);
            }
        }

        public void deleteFileIfExists(String path, boolean usingSnappy) {
            Path fsPath = this.getFullPath(path, usingSnappy);
            try {
                if (this.fileSystem.exists(fsPath)) {
                    this.fileSystem.delete(fsPath, true);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public Path getFullPath(String path, boolean usingSnappy) {
            return new Path(this.workingDir + path + (usingSnappy && this.codec != null ? QueryRecStatsCollector.FILE_SUFFIX_SNAPPY : QueryRecStatsCollector.FILE_SUFFIX));
        }
    }
}

