/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.freebsd;

import oshi.hardware.common.AbstractFirmware;
import oshi.util.ExecutingCommand;

final class FreeBsdFirmware
extends AbstractFirmware {
    private static final long serialVersionUID = 1L;

    FreeBsdFirmware() {
        this.init();
    }

    private void init() {
        String manufacturer = "";
        String manufacturerMarker = "Vendor:";
        String version = "";
        String versionMarker = "Version:";
        String releaseDate = "";
        String releaseDateMarker = "Release Date:";
        for (String checkLine : ExecutingCommand.runNative("dmidecode -t bios")) {
            if (checkLine.contains("Vendor:")) {
                manufacturer = checkLine.split("Vendor:")[1].trim();
                continue;
            }
            if (checkLine.contains("Version:")) {
                version = checkLine.split("Version:")[1].trim();
                continue;
            }
            if (!checkLine.contains("Release Date:")) continue;
            releaseDate = checkLine.split("Release Date:")[1].trim();
        }
        if (!manufacturer.isEmpty()) {
            this.setManufacturer(manufacturer);
        }
        if (!version.isEmpty()) {
            this.setVersion(version);
        }
        if (!releaseDate.isEmpty()) {
            try {
                this.setReleaseDate(String.format("%s-%s-%s", releaseDate.substring(6, 10), releaseDate.substring(0, 2), releaseDate.substring(3, 5)));
            }
            catch (StringIndexOutOfBoundsException e) {
                this.setReleaseDate(releaseDate);
            }
        }
    }
}

