/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableSort;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.ContextUtil;
import org.apache.kylin.query.relnode.OlapContext;
import org.apache.kylin.query.relnode.OlapRel;
import org.apache.kylin.query.util.ICutContextStrategy;

public class OlapSortRel
extends Sort
implements OlapRel {
    private ColumnRowType columnRowType;
    private OlapContext context;
    private Set<OlapContext> subContexts = Sets.newHashSet();
    private boolean needPushToSubCtx;

    public OlapSortRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RelCollation collation, RexNode offset, RexNode fetch) {
        super(cluster, traitSet, child, collation, offset, fetch);
        Preconditions.checkArgument((this.getConvention() == CONVENTION ? 1 : 0) != 0);
        Preconditions.checkArgument((this.getConvention() == child.getConvention() ? 1 : 0) != 0);
    }

    public OlapSortRel copy(RelTraitSet traitSet, RelNode newInput, RelCollation newCollation, RexNode offset, RexNode fetch) {
        return new OlapSortRel(this.getCluster(), traitSet, newInput, newCollation, offset, fetch);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.05);
    }

    @Override
    public void implementOlap(OlapRel.OlapImpl olapImpl) {
        List<Set<TblColRef>> sourceColumns;
        olapImpl.visitChild(this.getInput(), this);
        this.columnRowType = this.buildColumnRowType();
        if (this.context != null && this == this.context.getTopNode() && !this.context.isHasAgg()) {
            ContextUtil.amendAllColsIfNoAgg(this);
        }
        if (this.context != null) {
            for (RelFieldCollation fieldCollation : this.collation.getFieldCollations()) {
                int index = fieldCollation.getFieldIndex();
                SQLDigest.OrderEnum order = this.getOrderEnum(fieldCollation.getDirection());
                OlapRel olapChild = (OlapRel)this.getInput();
                TblColRef orderCol = olapChild.getColumnRowType().getAllColumns().get(index);
                this.context.addSort(orderCol, order);
                this.context.getAllColumns().addAll(orderCol.getSourceColumns());
            }
        } else if (this.needPushToSubCtx && CollectionUtils.isNotEmpty(sourceColumns = this.columnRowType.getSourceColumns())) {
            Set<TblColRef> colRefs = sourceColumns.stream().flatMap(Collection::stream).filter(tblColRef -> !tblColRef.getName().startsWith("_KY_")).collect(Collectors.toSet());
            ContextUtil.updateSubContexts(colRefs, this.subContexts);
        }
    }

    protected ColumnRowType buildColumnRowType() {
        return ((OlapRel)this.getInput()).getColumnRowType();
    }

    @Override
    public void implementRewrite(OlapRel.RewriteImpl rewriteImpl) {
        rewriteImpl.visitChild(this, this.getInput());
        if (this.context != null) {
            if (this.context.getRealization() == null) {
                return;
            }
            this.rowType = this.deriveRowType();
            this.columnRowType = this.buildColumnRowType();
        }
    }

    protected SQLDigest.OrderEnum getOrderEnum(RelFieldCollation.Direction direction) {
        if (direction == RelFieldCollation.Direction.DESCENDING) {
            return SQLDigest.OrderEnum.DESCENDING;
        }
        return SQLDigest.OrderEnum.ASCENDING;
    }

    @Override
    public EnumerableRel implementEnumerable(List<EnumerableRel> inputs) {
        return new EnumerableSort(this.getCluster(), this.getCluster().traitSetOf((RelTrait)EnumerableConvention.INSTANCE).replace((RelTrait)this.collation), (RelNode)OlapSortRel.sole(inputs), this.collation, this.offset, this.fetch);
    }

    @Override
    public boolean hasSubQuery() {
        OlapRel olapChild = (OlapRel)this.getInput();
        return olapChild.hasSubQuery();
    }

    @Override
    public RelTraitSet replaceTraitSet(RelTrait trait) {
        RelTraitSet oldTraitSet = this.traitSet;
        this.traitSet = this.traitSet.replace(trait);
        return oldTraitSet;
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("ctx", (Object)this.displayCtxId(this.context));
    }

    @Override
    public void implementCutContext(ICutContextStrategy.ContextCutImpl contextCutImpl) {
        this.context = null;
        this.columnRowType = null;
        contextCutImpl.visitChild(this.getInput());
    }

    @Override
    public void setContext(OlapContext context) {
        this.context = context;
        ((OlapRel)this.getInput()).setContext(context);
        this.subContexts.addAll(ContextUtil.collectSubContext(this.getInput()));
    }

    @Override
    public boolean pushRelInfoToContext(OlapContext context) {
        if (this.context == null && ((OlapRel)this.getInput()).pushRelInfoToContext(context)) {
            this.context = context;
            return true;
        }
        return false;
    }

    @Override
    public void implementContext(OlapRel.ContextImpl contextImpl, OlapRel.ContextVisitorState state) {
        contextImpl.fixSharedOlapTableScan((SingleRel)this);
        OlapRel.ContextVisitorState tempState = OlapRel.ContextVisitorState.init();
        contextImpl.visitChild(this.getInput(), this, tempState);
        this.subContexts.addAll(ContextUtil.collectSubContext(this.getInput()));
        if (this.context == null && this.subContexts.size() == 1 && this.getInput() == ((OlapContext)Lists.newArrayList(this.subContexts).get(0)).getTopNode()) {
            this.context = (OlapContext)Lists.newArrayList(this.subContexts).get(0);
            this.context.setTopNode(this);
        }
        state.merge(tempState);
    }

    @Override
    @Generated
    public ColumnRowType getColumnRowType() {
        return this.columnRowType;
    }

    @Override
    @Generated
    public OlapContext getContext() {
        return this.context;
    }

    @Override
    @Generated
    public Set<OlapContext> getSubContexts() {
        return this.subContexts;
    }

    @Generated
    public boolean isNeedPushToSubCtx() {
        return this.needPushToSubCtx;
    }

    @Override
    @Generated
    public void setSubContexts(Set<OlapContext> subContexts) {
        this.subContexts = subContexts;
    }

    @Generated
    public void setNeedPushToSubCtx(boolean needPushToSubCtx) {
        this.needPushToSubCtx = needPushToSubCtx;
    }
}

