/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.routing;

import java.util.List;
import lombok.Generated;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.metadata.cube.cuboid.NLayoutCandidate;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.realization.CapabilityResult;
import org.apache.kylin.metadata.realization.HybridRealization;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.IRealizationCandidate;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.query.routing.Candidate;
import org.apache.kylin.query.routing.QueryLayoutChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataflowCapabilityChecker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataflowCapabilityChecker.class);

    private DataflowCapabilityChecker() {
    }

    public static CapabilityResult check(NDataflow dataflow, Candidate candidate, SQLDigest digest) {
        log.info("Matching Layout in dataflow {}, SQL digest {}", (Object)dataflow, (Object)digest);
        CapabilityResult result = new CapabilityResult();
        if (digest.isLimitPrecedesAggr()) {
            log.info("Exclude NDataflow {} because there's limit preceding aggregation", (Object)dataflow);
            result.incapableCause = CapabilityResult.IncapableCause.create((CapabilityResult.IncapableType)CapabilityResult.IncapableType.LIMIT_PRECEDE_AGGR);
            return result;
        }
        NLayoutCandidate chosenCandidate = null;
        log.trace("Normal dataflow matching");
        List<NDataSegment> prunedSegments = candidate.getPrunedSegments(dataflow);
        NLayoutCandidate candidateAndInfluence = QueryLayoutChooser.selectLayoutCandidate(dataflow, prunedSegments, digest);
        if (candidateAndInfluence == null && QueryContext.current().isPartialMatchIndex()) {
            log.trace("Partial dataflow matching");
            candidateAndInfluence = QueryLayoutChooser.selectPartialLayoutCandidate(dataflow, prunedSegments, digest);
        } else if (candidateAndInfluence == null) {
            log.debug("select the layout candidate with high data integrity.");
            candidateAndInfluence = QueryLayoutChooser.selectHighIntegrityCandidate(dataflow, candidate, digest);
            if (candidateAndInfluence != null) {
                result.setPartialResult(true);
            }
        }
        if (candidateAndInfluence != null) {
            chosenCandidate = candidateAndInfluence;
            result.influences.addAll(candidateAndInfluence.getCapabilityResult().influences);
            log.info("Matched layout {} snapshot in dataflow {} ", (Object)chosenCandidate, (Object)dataflow);
        }
        if (chosenCandidate != null) {
            result.setCapable(true);
            result.setCandidate(dataflow.isStreaming(), (IRealizationCandidate)chosenCandidate);
            result.setCost(chosenCandidate.getCost());
        } else {
            result.setCapable(false);
        }
        return result;
    }

    public static CapabilityResult hybridRealizationCheck(HybridRealization r, Candidate candidate, SQLDigest digest) {
        CapabilityResult result = new CapabilityResult();
        DataflowCapabilityChecker.resolveSegmentsOverlap(r, candidate.getQueryableSeg().getStreamingSegments());
        for (IRealization realization : r.getRealizations()) {
            NDataflow df = (NDataflow)realization;
            CapabilityResult child = DataflowCapabilityChecker.check(df, candidate, digest);
            result.setCandidate(df.isStreaming(), child);
            if (child.isCapable()) {
                result.setCost(Math.min(result.getCost(), child.getCost(df.isStreaming())));
                result.setCapable(true);
                result.influences.addAll(child.influences);
                continue;
            }
            result.incapableCause = child.incapableCause;
        }
        result.setCost(result.getCost() - 1.0);
        return result;
    }

    private static void resolveSegmentsOverlap(HybridRealization realization, List<NDataSegment> prunedStreamingSegments) {
        long end = realization.getBatchRealization().getDateRangeEnd();
        if (end != Long.MIN_VALUE) {
            String segments = prunedStreamingSegments.toString();
            log.info("Before resolve segments overlap between batch and stream of fusion model: {}", (Object)segments);
            SegmentRange.KafkaOffsetPartitionedSegmentRange range = new SegmentRange.KafkaOffsetPartitionedSegmentRange(Long.valueOf(end), Long.valueOf(Long.MAX_VALUE));
            List list = ((NDataflow)realization.getStreamingRealization()).getQueryableSegmentsByRange((SegmentRange)range);
            prunedStreamingSegments.removeIf(seg -> !list.contains(seg));
            segments = prunedStreamingSegments.toString();
            log.info("After resolve segments overlap between batch and stream of fusion model: {}", (Object)segments);
        }
    }
}

