/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.schema;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.query.schema.OlapTable;

public class OlapSchema
extends AbstractSchema {
    private final KylinConfig config;
    private final String project;
    private final String schemaName;
    private final List<TableDesc> tables;
    private final Map<String, List<NDataModel>> modelsMap;
    private String starSchemaUrl;
    private String starSchemaUser;
    private String starSchemaPassword;

    public OlapSchema(KylinConfig kylinConfig, String project, String schemaName, List<TableDesc> tables, Map<String, List<NDataModel>> modelsMap) {
        this.project = project;
        this.schemaName = schemaName;
        this.tables = tables;
        this.modelsMap = modelsMap;
        this.config = kylinConfig;
        this.init();
    }

    private void init() {
        this.starSchemaUrl = this.config.getHiveUrl();
        this.starSchemaUser = this.config.getHiveUser();
        this.starSchemaPassword = this.config.getHivePassword();
    }

    public Map<String, Table> getTableMap() {
        return this.createTableMap();
    }

    public boolean hasTables() {
        return this.tables != null && !this.tables.isEmpty();
    }

    private Map<String, Table> createTableMap() {
        HashMap<String, Table> olapTables = new HashMap<String, Table>();
        for (TableDesc tableDesc : this.tables) {
            String tableName = tableDesc.getName();
            OlapTable table = new OlapTable(this, tableDesc, this.modelsMap);
            olapTables.put(tableName, (Table)table);
        }
        return olapTables;
    }

    public KylinConfig getConfig() {
        return this.config;
    }

    public String getProject() {
        return this.project;
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public List<TableDesc> getTables() {
        return this.tables;
    }

    @Generated
    public Map<String, List<NDataModel>> getModelsMap() {
        return this.modelsMap;
    }

    @Generated
    public String getStarSchemaUrl() {
        return this.starSchemaUrl;
    }

    @Generated
    public String getStarSchemaUser() {
        return this.starSchemaUser;
    }

    @Generated
    public String getStarSchemaPassword() {
        return this.starSchemaPassword;
    }
}

