/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller.v2;

import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.response.DataResult;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.service.TableService;
import org.apache.kylin.rest.util.TableUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/tables"}, produces={"application/vnd.apache.kylin-v2+json"})
public class NTableControllerV2
extends NBasicController {
    @Autowired
    private TableService tableService;

    @ApiOperation(value="getTableDesc", tags={"AI"})
    @GetMapping(value={""})
    @ResponseBody
    public EnvelopeResponse<List<TableDesc>> getTableDesc(@RequestParam(value="project") String project, @RequestParam(value="table", required=false) String table, @RequestParam(value="database", required=false) String database, @RequestParam(value="is_fuzzy", required=false, defaultValue="false") boolean isFuzzy, @RequestParam(value="ext", required=false, defaultValue="true") boolean withExt, @RequestParam(value="page_offset", required=false, defaultValue="0") Integer offset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer limit, @RequestParam(value="source_type", required=false, defaultValue="9") Integer sourceType) throws IOException {
        this.checkProjectName(project);
        this.checkNonNegativeIntegerArg("page_offset", offset);
        if (sourceType == 1) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.UNSUPPORTED_STREAMING_OPERATION, MsgPicker.getMsg().getStreamingOperationNotSupport());
        }
        int returnTableSize = TableUtils.calculateTableSize((int)offset, (int)limit);
        Pair tableDescWithActualSize = this.tableService.getTableDesc(project, withExt, table, database, isFuzzy, Collections.singletonList(sourceType), returnTableSize);
        return new EnvelopeResponse("000", (Object)DataResult.getCustom((Pair)tableDescWithActualSize, (int)offset, (int)limit).getValue(), "");
    }
}

