/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.curator.RetryPolicy;
import org.apache.curator.drivers.TracerDriver;
import org.apache.curator.ensemble.EnsembleProvider;
import org.apache.curator.framework.CuratorFramework;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.zookeeper.ConditionalOnZookeeperEnabled;
import org.springframework.cloud.zookeeper.CuratorFactory;
import org.springframework.cloud.zookeeper.CuratorFrameworkCustomizer;
import org.springframework.cloud.zookeeper.ZookeeperProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnZookeeperEnabled
@EnableConfigurationProperties
public class ZookeeperAutoConfiguration {
    private static final Log log = LogFactory.getLog(ZookeeperAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public ZookeeperProperties zookeeperProperties() {
        return new ZookeeperProperties();
    }

    @Bean(destroyMethod="close")
    @ConditionalOnMissingBean
    public CuratorFramework curatorFramework(ZookeeperProperties properties, RetryPolicy retryPolicy, ObjectProvider<CuratorFrameworkCustomizer> optionalCuratorFrameworkCustomizerProvider, ObjectProvider<EnsembleProvider> optionalEnsembleProvider, ObjectProvider<TracerDriver> optionalTracerDriverProvider) throws Exception {
        return CuratorFactory.curatorFramework(properties, retryPolicy, () -> optionalCuratorFrameworkCustomizerProvider.orderedStream(), () -> optionalEnsembleProvider.getIfAvailable(), () -> optionalTracerDriverProvider.getIfAvailable());
    }

    @Bean
    @ConditionalOnMissingBean
    public RetryPolicy exponentialBackoffRetry(ZookeeperProperties properties) {
        return CuratorFactory.retryPolicy(properties);
    }
}

