/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.redis;

import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.data.redis.core.ReactiveRedisOperations;
import org.springframework.session.MapSession;
import org.springframework.session.ReactiveSessionRepository;
import org.springframework.session.SaveMode;
import org.springframework.session.Session;
import org.springframework.session.data.redis.RedisSessionMapper;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class ReactiveRedisSessionRepository
implements ReactiveSessionRepository<RedisSession> {
    public static final String DEFAULT_NAMESPACE = "spring:session";
    private final ReactiveRedisOperations<String, Object> sessionRedisOperations;
    private String namespace = "spring:session:";
    private Integer defaultMaxInactiveInterval;
    private SaveMode saveMode = SaveMode.ON_SET_ATTRIBUTE;

    public ReactiveRedisSessionRepository(ReactiveRedisOperations<String, Object> sessionRedisOperations) {
        Assert.notNull(sessionRedisOperations, (String)"sessionRedisOperations cannot be null");
        this.sessionRedisOperations = sessionRedisOperations;
    }

    public void setRedisKeyNamespace(String namespace) {
        Assert.hasText((String)namespace, (String)"namespace cannot be null or empty");
        this.namespace = namespace.trim() + ":";
    }

    public void setDefaultMaxInactiveInterval(int defaultMaxInactiveInterval) {
        this.defaultMaxInactiveInterval = defaultMaxInactiveInterval;
    }

    public void setSaveMode(SaveMode saveMode) {
        Assert.notNull((Object)saveMode, (String)"saveMode must not be null");
        this.saveMode = saveMode;
    }

    public ReactiveRedisOperations<String, Object> getSessionRedisOperations() {
        return this.sessionRedisOperations;
    }

    public Mono<RedisSession> createSession() {
        return Mono.defer(() -> {
            MapSession cached = new MapSession();
            if (this.defaultMaxInactiveInterval != null) {
                cached.setMaxInactiveInterval(Duration.ofSeconds(this.defaultMaxInactiveInterval.intValue()));
            }
            RedisSession session = new RedisSession(cached, true);
            return Mono.just((Object)session);
        });
    }

    public Mono<Void> save(RedisSession session) {
        if (session.isNew) {
            return session.save();
        }
        String sessionKey = this.getSessionKey(session.hasChangedSessionId() ? session.originalSessionId : session.getId());
        return this.sessionRedisOperations.hasKey((Object)sessionKey).flatMap(exists -> exists != false ? session.save() : Mono.error((Throwable)new IllegalStateException("Session was invalidated")));
    }

    public Mono<RedisSession> findById(String id) {
        String sessionKey = this.getSessionKey(id);
        return this.sessionRedisOperations.opsForHash().entries((Object)sessionKey).collectMap(e -> e.getKey().toString(), Map.Entry::getValue).filter(map -> !map.isEmpty()).map((Function)new RedisSessionMapper(id)).filter(session -> !session.isExpired()).map(session -> new RedisSession((MapSession)session, false)).switchIfEmpty(Mono.defer(() -> this.deleteById(id).then(Mono.empty())));
    }

    public Mono<Void> deleteById(String id) {
        String sessionKey = this.getSessionKey(id);
        return this.sessionRedisOperations.delete((Object[])new String[]{sessionKey}).then();
    }

    private static String getAttributeKey(String attributeName) {
        return "sessionAttr:" + attributeName;
    }

    private String getSessionKey(String sessionId) {
        return this.namespace + "sessions:" + sessionId;
    }

    final class RedisSession
    implements Session {
        private final MapSession cached;
        private final Map<String, Object> delta = new HashMap<String, Object>();
        private boolean isNew;
        private String originalSessionId;

        RedisSession(MapSession cached, boolean isNew) {
            this.cached = cached;
            this.isNew = isNew;
            this.originalSessionId = cached.getId();
            if (this.isNew) {
                this.delta.put("creationTime", cached.getCreationTime().toEpochMilli());
                this.delta.put("maxInactiveInterval", (int)cached.getMaxInactiveInterval().getSeconds());
                this.delta.put("lastAccessedTime", cached.getLastAccessedTime().toEpochMilli());
            }
            if (this.isNew || ReactiveRedisSessionRepository.this.saveMode == SaveMode.ALWAYS) {
                this.getAttributeNames().forEach(attributeName -> this.delta.put(ReactiveRedisSessionRepository.getAttributeKey(attributeName), cached.getAttribute(attributeName)));
            }
        }

        public String getId() {
            return this.cached.getId();
        }

        public String changeSessionId() {
            return this.cached.changeSessionId();
        }

        public <T> T getAttribute(String attributeName) {
            Object attributeValue = this.cached.getAttribute(attributeName);
            if (attributeValue != null && ReactiveRedisSessionRepository.this.saveMode.equals((Object)SaveMode.ON_GET_ATTRIBUTE)) {
                this.delta.put(ReactiveRedisSessionRepository.getAttributeKey(attributeName), attributeValue);
            }
            return (T)attributeValue;
        }

        public Set<String> getAttributeNames() {
            return this.cached.getAttributeNames();
        }

        public void setAttribute(String attributeName, Object attributeValue) {
            this.cached.setAttribute(attributeName, attributeValue);
            this.delta.put(ReactiveRedisSessionRepository.getAttributeKey(attributeName), attributeValue);
        }

        public void removeAttribute(String attributeName) {
            this.cached.removeAttribute(attributeName);
            this.delta.put(ReactiveRedisSessionRepository.getAttributeKey(attributeName), null);
        }

        public Instant getCreationTime() {
            return this.cached.getCreationTime();
        }

        public void setLastAccessedTime(Instant lastAccessedTime) {
            this.cached.setLastAccessedTime(lastAccessedTime);
            this.delta.put("lastAccessedTime", this.getLastAccessedTime().toEpochMilli());
        }

        public Instant getLastAccessedTime() {
            return this.cached.getLastAccessedTime();
        }

        public void setMaxInactiveInterval(Duration interval) {
            this.cached.setMaxInactiveInterval(interval);
            this.delta.put("maxInactiveInterval", (int)this.getMaxInactiveInterval().getSeconds());
        }

        public Duration getMaxInactiveInterval() {
            return this.cached.getMaxInactiveInterval();
        }

        public boolean isExpired() {
            return this.cached.isExpired();
        }

        private boolean hasChangedSessionId() {
            return !this.getId().equals(this.originalSessionId);
        }

        private Mono<Void> save() {
            return Mono.defer(() -> this.saveChangeSessionId().then(this.saveDelta()).doOnSuccess(aVoid -> {
                this.isNew = false;
            }));
        }

        private Mono<Void> saveDelta() {
            if (this.delta.isEmpty()) {
                return Mono.empty();
            }
            String sessionKey = ReactiveRedisSessionRepository.this.getSessionKey(this.getId());
            Mono update = ReactiveRedisSessionRepository.this.sessionRedisOperations.opsForHash().putAll((Object)sessionKey, new HashMap<String, Object>(this.delta));
            Mono setTtl = this.getMaxInactiveInterval().getSeconds() >= 0L ? ReactiveRedisSessionRepository.this.sessionRedisOperations.expire((Object)sessionKey, this.getMaxInactiveInterval()) : ReactiveRedisSessionRepository.this.sessionRedisOperations.persist((Object)sessionKey);
            return update.and((Publisher)setTtl).and(s -> {
                this.delta.clear();
                s.onComplete();
            }).then();
        }

        private Mono<Void> saveChangeSessionId() {
            if (!this.hasChangedSessionId()) {
                return Mono.empty();
            }
            String sessionId = this.getId();
            Publisher replaceSessionId = s -> {
                this.originalSessionId = sessionId;
                s.onComplete();
            };
            if (this.isNew) {
                return Mono.from((Publisher)replaceSessionId);
            }
            String originalSessionKey = ReactiveRedisSessionRepository.this.getSessionKey(this.originalSessionId);
            String sessionKey = ReactiveRedisSessionRepository.this.getSessionKey(sessionId);
            return ReactiveRedisSessionRepository.this.sessionRedisOperations.rename((Object)originalSessionKey, (Object)sessionKey).and(replaceSessionId);
        }
    }
}

