/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.substrait.plan;

import io.substrait.proto.Plan;
import io.substrait.proto.PlanRel;
import io.substrait.proto.RelRoot;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.gluten.substrait.extensions.AdvancedExtensionNode;
import org.apache.gluten.substrait.extensions.FunctionMappingNode;
import org.apache.gluten.substrait.rel.RelNode;
import org.apache.gluten.substrait.type.TypeNode;

public class PlanNode
implements Serializable {
    private final List<FunctionMappingNode> mappingNodes = new ArrayList<FunctionMappingNode>();
    private final List<RelNode> relNodes = new ArrayList<RelNode>();
    private final List<String> outNames = new ArrayList<String>();
    private TypeNode outputSchema = null;
    private AdvancedExtensionNode extension = null;

    PlanNode(List<FunctionMappingNode> mappingNodes, List<RelNode> relNodes, List<String> outNames) {
        this.mappingNodes.addAll(mappingNodes);
        this.relNodes.addAll(relNodes);
        this.outNames.addAll(outNames);
    }

    PlanNode(List<FunctionMappingNode> mappingNodes, List<RelNode> relNodes, List<String> outNames, TypeNode outputSchema, AdvancedExtensionNode extension) {
        this.mappingNodes.addAll(mappingNodes);
        this.relNodes.addAll(relNodes);
        this.outNames.addAll(outNames);
        this.outputSchema = outputSchema;
        this.extension = extension;
    }

    PlanNode(AdvancedExtensionNode extension) {
        this.extension = extension;
    }

    public Plan toProtobuf() {
        Plan.Builder planBuilder = Plan.newBuilder();
        for (FunctionMappingNode mappingNode : this.mappingNodes) {
            planBuilder.addExtensions(mappingNode.toProtobuf());
        }
        for (RelNode relNode : this.relNodes) {
            PlanRel.Builder planRelBuilder = PlanRel.newBuilder();
            RelRoot.Builder relRootBuilder = RelRoot.newBuilder();
            relRootBuilder.setInput(relNode.toProtobuf());
            for (String name : this.outNames) {
                relRootBuilder.addNames(name);
            }
            if (this.outputSchema != null) {
                relRootBuilder.setOutputSchema(this.outputSchema.toProtobuf().getStruct());
            }
            planRelBuilder.setRoot(relRootBuilder.build());
            planBuilder.addRelations(planRelBuilder.build());
        }
        if (this.extension != null) {
            planBuilder.setAdvancedExtensions(this.extension.toProtobuf());
        }
        return planBuilder.build();
    }
}

