/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import java.util.Map;
import lombok.Generated;
import org.apache.kylin.common.SystemPropertiesCache;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTestCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractTestCase.class);
    private static final Map<String, String> BEFORE_CLASS_PROPERTY_MAP = Maps.newHashMap();
    private final Map<String, String> METHOD_PROPERTY_MAP = Maps.newHashMap();

    public static void overwriteSystemPropBeforeClass(String property, String name) {
        Unsafe.overwriteSystemProp(BEFORE_CLASS_PROPERTY_MAP, (String)property, (String)name);
    }

    @AfterClass
    @AfterAll
    public static void restoreSystemPropsOverwriteBeforeClass() {
        Unsafe.restoreAllSystemProp(BEFORE_CLASS_PROPERTY_MAP);
    }

    public final void overwriteSystemProp(String property, String value) {
        Unsafe.overwriteSystemProp(this.METHOD_PROPERTY_MAP, (String)property, (String)value);
    }

    @After
    @AfterEach
    public final void restoreSystemProps() {
        Unsafe.restoreAllSystemProp(this.METHOD_PROPERTY_MAP);
    }

    public final void restoreSystemProp(String property) {
        if (!this.METHOD_PROPERTY_MAP.containsKey(property) || this.METHOD_PROPERTY_MAP.get(property) == null) {
            SystemPropertiesCache.clearProperty((String)property);
        } else {
            SystemPropertiesCache.setProperty((String)property, (String)this.METHOD_PROPERTY_MAP.get(property));
        }
        this.METHOD_PROPERTY_MAP.remove(property);
    }
}

