/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import io.kyligence.config.core.loader.IExternalConfigLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kylin.common.ICachedExternalConfigLoader;
import org.apache.kylin.common.PropertiesDelegate;
import org.apache.kylin.common.TestExternalConfigLoader;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableMap;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class PropertiesDelegateTest {
    private PropertiesDelegate delegate;

    PropertiesDelegateTest() {
    }

    @BeforeEach
    void setup() {
        Properties properties = new Properties();
        properties.put("key_in_prop", "v0");
        properties.put("key_override_external", "v1");
        Properties externalProperties = new Properties();
        externalProperties.put("key_override_external", "v11");
        externalProperties.put("key_in_external", "v2");
        TestExternalConfigLoader testExternalConfigLoader = new TestExternalConfigLoader(externalProperties);
        this.delegate = new PropertiesDelegate(properties, (IExternalConfigLoader)testExternalConfigLoader);
    }

    @Test
    void testReloadProperties() {
        Properties properties = new Properties();
        this.delegate.reloadProperties(properties);
        Assertions.assertNull((Object)this.delegate.getProperty("key_in_prop"));
        Assertions.assertEquals((Object)"v11", (Object)this.delegate.getProperty("key_override_external"));
        properties.put("key_override_external", "v1_1");
        this.delegate.reloadProperties(properties);
        Assertions.assertEquals((Object)"v1_1", (Object)this.delegate.getProperty("key_override_external"));
    }

    @Test
    void testGetProperty() {
        Assertions.assertEquals((Object)"v0", (Object)this.delegate.getProperty("key_in_prop"));
        Assertions.assertEquals((Object)"v1", (Object)this.delegate.getProperty("key_override_external"));
        Assertions.assertEquals((Object)"v2", (Object)this.delegate.getProperty("key_in_external"));
        Assertions.assertEquals((Object)"v2", (Object)this.delegate.getProperty("key_in_external", "default_value"));
        Assertions.assertNull((Object)this.delegate.getProperty("key_none_exists"));
        Assertions.assertEquals((Object)"default_value", (Object)this.delegate.getProperty("key_none_exists", "default_value"));
    }

    @Test
    void testPut() {
        this.delegate.put((Object)"key_in_prop", (Object)"update_v0");
        Assertions.assertEquals((Object)"update_v0", (Object)this.delegate.getProperty("key_in_prop"));
        this.delegate.put((Object)"key_override_external", (Object)"update_v1");
        Assertions.assertEquals((Object)"update_v1", (Object)this.delegate.getProperty("key_override_external"));
        this.delegate.put((Object)"key_in_external", (Object)"update_v2");
        Assertions.assertEquals((Object)"update_v2", (Object)this.delegate.getProperty("key_in_external"));
    }

    @Test
    void testPutAll() {
        int originSize = this.delegate.size();
        HashMap map1 = Maps.newHashMap();
        map1.put("k1", "v1");
        map1.put("k2", "v2");
        map1.put("k3", "v3");
        this.delegate.putAll((Map)map1);
        Assertions.assertEquals((int)(originSize + map1.size()), (int)this.delegate.size());
        Assertions.assertEquals((Object)"v1", (Object)this.delegate.getProperty("k1"));
    }

    @Test
    void testSetProperty() {
        this.delegate.setProperty("key_in_prop", "update_v0");
        Assertions.assertEquals((Object)"update_v0", (Object)this.delegate.getProperty("key_in_prop"));
        this.delegate.setProperty("key_override_external", "update_v1");
        Assertions.assertEquals((Object)"update_v1", (Object)this.delegate.getProperty("key_override_external"));
        this.delegate.setProperty("key_in_external", "update_v2");
        Assertions.assertEquals((Object)"update_v2", (Object)this.delegate.getProperty("key_in_external"));
    }

    @Test
    void testSize() {
        Assertions.assertEquals((int)3, (int)this.delegate.size());
    }

    @Test
    void testEntrySet() {
        Set entries = this.delegate.entrySet();
        Assertions.assertEquals((int)3, (int)entries.size());
    }

    @Test
    void testKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        Enumeration enumer = this.delegate.keys();
        while (enumer.hasMoreElements()) {
            keys.add((String)enumer.nextElement());
        }
        Assertions.assertEquals((int)3, (int)keys.size());
        Assertions.assertEquals((Object)"key_in_external, key_in_prop, key_override_external", (Object)keys.stream().sorted().collect(Collectors.joining(", ")));
    }

    @Test
    void testEqualsAndHashCode() {
        HashSet<Object> sets = new HashSet<Object>();
        sets.add(this.delegate);
        Assertions.assertEquals((int)1, (int)sets.size());
        sets.add(this.delegate);
        Assertions.assertEquals((int)1, (int)sets.size());
        Assertions.assertEquals((Object)this.delegate, (Object)this.delegate);
        this.delegate.reloadProperties(new Properties());
        sets.add(this.delegate);
        Assertions.assertEquals((int)2, (int)sets.size());
        Properties properties = new Properties();
        sets.add(properties);
        Assertions.assertEquals((int)3, (int)sets.size());
        sets.add(properties);
        Assertions.assertEquals((int)3, (int)sets.size());
        properties.put("1", "v1");
        sets.add(properties);
        Assertions.assertEquals((int)4, (int)sets.size());
    }

    @Test
    void testContainsKey() {
        Assertions.assertTrue((boolean)this.delegate.containsKey((Object)"key_in_prop"));
        Assertions.assertTrue((boolean)this.delegate.containsKey((Object)"key_override_external"));
        Assertions.assertTrue((boolean)this.delegate.containsKey((Object)"key_in_external"));
        Assertions.assertFalse((boolean)this.delegate.containsKey((Object)"not_key"));
    }

    @Test
    void testContainsValue() {
        Assertions.assertTrue((boolean)this.delegate.containsValue((Object)"v0"));
        Assertions.assertTrue((boolean)this.delegate.containsValue((Object)"v11"));
        Assertions.assertTrue((boolean)this.delegate.containsValue((Object)"v2"));
        Assertions.assertFalse((boolean)this.delegate.containsValue((Object)"not_value"));
    }

    @Test
    void testIsEmpty() {
        Assertions.assertFalse((boolean)this.delegate.isEmpty());
        PropertiesDelegate emptyDelegate = new PropertiesDelegate(new Properties(), null);
        Assertions.assertTrue((boolean)emptyDelegate.isEmpty());
    }

    @Test
    void testClear() {
        Assertions.assertEquals((int)3, (int)this.delegate.size());
        this.delegate.clear();
        Assertions.assertEquals((int)2, (int)this.delegate.size());
    }

    @Test
    void testConstruct() {
        Properties properties = new Properties();
        properties.put("key_in_prop", "v0");
        PropertiesDelegate p = new PropertiesDelegate(properties, null);
        Assertions.assertEquals((int)1, (int)p.size());
        TestExternalConfigLoader testExternalConfigLoader = new TestExternalConfigLoader(properties);
        PropertiesDelegate p2 = new PropertiesDelegate(new Properties(), (IExternalConfigLoader)testExternalConfigLoader);
        Assertions.assertEquals((int)1, (int)p2.size());
        ICachedExternalConfigLoader iCachedExternalConfigLoader = new ICachedExternalConfigLoader(){

            public ImmutableMap<Object, Object> getPropertyEntries() {
                return ImmutableMap.of((Object)"key_in_prop", (Object)"v0");
            }

            public String getConfig() {
                return null;
            }

            public String getProperty(String s) {
                return null;
            }
        };
        p2 = new PropertiesDelegate(new Properties(), (IExternalConfigLoader)iCachedExternalConfigLoader);
        Assertions.assertEquals((int)1, (int)p2.size());
    }

    @Test
    void testNotSupport() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.delegate.remove((Object)"a", (Object)"b"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> ((PropertiesDelegate)this.delegate).toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.delegate.forEach((k, v) -> {}));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.delegate.replace((Object)"a", (Object)"b"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.delegate.replace((Object)"a", (Object)"b", (Object)"b2"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.delegate.computeIfAbsent((Object)"a", k -> ""));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.delegate.computeIfPresent((Object)"a", (k, v) -> ""));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.delegate.compute((Object)"a", (k, v) -> ""));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.delegate.merge((Object)"a", (Object)"b", (k, v) -> ""));
    }
}

