/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.resources.ProjectRawResource;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.io.ByteSource;

public class RawResourceTool {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;

    public static ProjectRawResource createProjectRawResource(String projectName, long mvcc, String uuid) {
        ProjectRawResource resource = new ProjectRawResource();
        resource.setMetaKey(projectName);
        resource.setName(projectName);
        resource.setUuid(uuid);
        resource.setContent(RawResourceTool.createContent(projectName, uuid));
        resource.setTs(Long.valueOf(System.currentTimeMillis()));
        resource.setMvcc(mvcc);
        return resource;
    }

    public static ProjectRawResource createProjectRawResource(String projectName, long mvcc) {
        return RawResourceTool.createProjectRawResource(projectName, mvcc, UUID.randomUUID().toString());
    }

    public static byte[] createContent(String projectName, String uuid) {
        return ("{ \"uuid\" : \"" + uuid + "\",\"meta_key\" : \"" + projectName + "\",\"name\" : \"" + projectName + "\"}").getBytes(DEFAULT_CHARSET);
    }

    public static ByteSource createByteSourceByPath(String path) {
        Pair pair = MetadataType.splitKeyWithType((String)path);
        String projectName = (String)pair.getSecond();
        return ByteSource.wrap((byte[])("{ \"uuid\" : \"" + UUID.randomUUID() + "\",\"meta_key\" : \"" + projectName + "\",\"name\" : \"" + projectName + "\"}").getBytes(DEFAULT_CHARSET));
    }

    public static ByteSource createByteSource(String projectName) {
        return ByteSource.wrap((byte[])("{ \"uuid\" : \"" + UUID.randomUUID() + "\",\"meta_key\" : \"" + projectName + "\",\"name\" : \"" + projectName + "\"}").getBytes(DEFAULT_CHARSET));
    }
}

