/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.MockMetaContent;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.SnapshotRawResource;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.TestUtils;
import org.apache.kylin.guava30.shaded.common.io.ByteSource;
import org.apache.kylin.junit.annotation.MetadataInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@MetadataInfo(project="ssb")
class SnapshotRawResourceTest {
    SnapshotRawResourceTest() {
    }

    @BeforeEach
    void before() throws JsonProcessingException {
        MockMetaContent mockContent = new MockMetaContent("abc", 18);
        byte[] mockContentJson = JsonUtil.writeValueAsBytes((Object)mockContent);
        ResourceStore resourceStore = ResourceStore.getKylinMetaStore((KylinConfig)TestUtils.getTestConfig());
        resourceStore.putResourceWithoutCheck("TABLE_INFO/abc", ByteSource.wrap((byte[])mockContentJson), 123L, 101L);
    }

    @Test
    void testRawResourceByteSourceSerializer() throws IOException {
        ResourceStore resourceStore = ResourceStore.getKylinMetaStore((KylinConfig)TestUtils.getTestConfig());
        SnapshotRawResource rawSnapshotRes = new SnapshotRawResource(resourceStore.getResource("TABLE_INFO/abc"));
        MockMetaContent mockContentSer = (MockMetaContent)JsonUtil.readValue((byte[])rawSnapshotRes.getByteSource().read(), MockMetaContent.class);
        Assertions.assertEquals((Object)"abc", (Object)mockContentSer.getName());
        Assertions.assertEquals((int)18, (int)mockContentSer.getAge());
    }

    @Test
    void testSnapShotRawResourceSerializer() throws IOException {
        ResourceStore resourceStore = ResourceStore.getKylinMetaStore((KylinConfig)TestUtils.getTestConfig());
        SnapshotRawResource rawSnapshotRes = new SnapshotRawResource(resourceStore.getResource("TABLE_INFO/abc"));
        String snapshotRawJson = JsonUtil.writeValueAsString((Object)rawSnapshotRes);
        Assertions.assertEquals((Object)"{\"byte_source\":\"eyJuYW1lIjoiYWJjIiwiYWdlIjoxOH0=\",\"timestamp\":123,\"mvcc\":101}", (Object)snapshotRawJson);
    }

    @Test
    void testSnapShotRawResourceDeSerializer() throws IOException {
        SnapshotRawResource snapshotRawResDes = (SnapshotRawResource)JsonUtil.readValue((byte[])"{\"byte_source\":\"eyJuYW1lIjoiYWJjIiwiYWdlIjoxOH0=\",\"timestamp\":123,\"mvcc\":101}".getBytes(Charset.defaultCharset()), SnapshotRawResource.class);
        Assertions.assertEquals((long)101L, (long)snapshotRawResDes.getMvcc());
        Assertions.assertEquals((long)123L, (long)snapshotRawResDes.getTimestamp());
        MockMetaContent mockContentDeSer = (MockMetaContent)JsonUtil.readValue((byte[])snapshotRawResDes.getByteSource().read(), MockMetaContent.class);
        Assertions.assertEquals((int)18, (int)mockContentDeSer.getAge());
        Assertions.assertEquals((Object)"abc", (Object)mockContentDeSer.getName());
    }
}

