/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence.metadata;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.metadata.FileSystemMetadataStore;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.junit.annotation.MetadataInfo;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MetadataInfo(onlyProps=true)
class HDFSMetadataStoreTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(HDFSMetadataStoreTest.class);

    HDFSMetadataStoreTest() {
    }

    @Test
    void testStartKEWithBackupDir() throws IOException {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        KylinConfig newKylinConfig = KylinConfig.createKylinConfig((KylinConfig)kylinConfig);
        newKylinConfig.setMetadataUrl(kylinConfig.getMetadataUrl().getIdentifier() + "@hdfs");
        String hdfsWorkingDir = newKylinConfig.getHdfsWorkingDirectory();
        String backupFolder = HadoopUtil.getBackupFolder((KylinConfig)newKylinConfig);
        Assert.assertEquals((Object)(hdfsWorkingDir + "_backup"), (Object)backupFolder);
        FileSystemMetadataStore hdfsMetadataStore = new FileSystemMetadataStore(newKylinConfig);
        String rootPath = hdfsMetadataStore.getRootPath().toString();
        Assert.assertTrue((boolean)rootPath.endsWith("/backup_0"));
        FileSystem fileSystem = HadoopUtil.getFileSystem((String)hdfsWorkingDir);
        fileSystem.mkdirs(new Path(backupFolder + "/1_backup"));
        FileSystemMetadataStore hdfsMetadataStore2 = new FileSystemMetadataStore(newKylinConfig);
        String rootPath2 = hdfsMetadataStore2.getRootPath().toString();
        Assert.assertTrue((boolean)rootPath2.endsWith("/1_backup"));
        Awaitility.await().pollDelay(2L, TimeUnit.SECONDS).until(() -> true);
        fileSystem.mkdirs(new Path(backupFolder + "/2_backup"));
        fileSystem.createNewFile(new Path(backupFolder + "/2_backup", "metadata.zip"));
        FileSystemMetadataStore hdfsMetadataStore3 = new FileSystemMetadataStore(newKylinConfig);
        String rootPath3 = hdfsMetadataStore3.getRootPath().toString();
        Assert.assertTrue((boolean)rootPath3.endsWith("/2_backup"));
        Awaitility.await().pollDelay(2L, TimeUnit.SECONDS).until(() -> true);
        fileSystem.mkdirs(new Path(backupFolder + "/3_backup"));
        fileSystem.mkdirs(new Path(backupFolder + "/3_backup/core_meta"));
        FileSystemMetadataStore hdfsMetadataStore4 = new FileSystemMetadataStore(newKylinConfig);
        String rootPath4 = hdfsMetadataStore4.getRootPath().toString();
        LOGGER.info("Root path for new version KE: {}", (Object)rootPath3);
        Assert.assertTrue((boolean)rootPath4.endsWith("/3_backup/core_meta"));
    }
}

