/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.util.HashMap;
import org.apache.kylin.common.util.ImplementationSwitch;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ImplementationSwitchTest {
    ImplementationSwitch<I> sw;

    public ImplementationSwitchTest() {
        HashMap<Integer, String> impls = new HashMap<Integer, String>();
        impls.put(0, "non.exist.class");
        impls.put(1, Impl1.class.getName());
        impls.put(2, Impl2.class.getName());
        this.sw = new ImplementationSwitch(impls, I.class);
    }

    @Test
    public void test() {
        Assert.assertTrue((boolean)(this.sw.get(1) instanceof Impl1));
        Assert.assertTrue((boolean)(this.sw.get(2) instanceof Impl2));
    }

    @Test
    public void testException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.sw.get(0));
    }

    public static class Impl2
    implements I {
    }

    public static class Impl1
    implements I {
    }

    public static interface I {
    }
}

