/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.client;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.celeborn.client.ShuffleClientImpl;
import org.apache.celeborn.client.read.CelebornInputStream;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.identity.UserIdentifier;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.rpc.RpcEndpointRef;
import org.apache.celeborn.common.util.CelebornHadoopUtils;
import org.apache.celeborn.common.write.PushState;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ShuffleClient {
    private static volatile ShuffleClient _instance;
    private static volatile boolean initialized;
    private static volatile FileSystem hdfsFs;
    private static Logger logger;

    public static void reset() {
        _instance = null;
        initialized = false;
        hdfsFs = null;
    }

    protected ShuffleClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ShuffleClient get(String appUniqueId, String driverHost, int port, CelebornConf conf, UserIdentifier userIdentifier, boolean isDriver) {
        if (null != _instance && initialized) return _instance;
        Class<ShuffleClient> clazz = ShuffleClient.class;
        synchronized (ShuffleClient.class) {
            if (null == _instance) {
                _instance = new ShuffleClientImpl(appUniqueId, conf, userIdentifier, isDriver);
                _instance.setupLifecycleManagerRef(driverHost, port);
                initialized = true;
            } else {
                if (initialized) return _instance;
                _instance.shutdown();
                _instance = new ShuffleClientImpl(appUniqueId, conf, userIdentifier, isDriver);
                _instance.setupLifecycleManagerRef(driverHost, port);
                initialized = true;
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return _instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FileSystem getHdfsFs(CelebornConf conf) {
        if (null != hdfsFs) return hdfsFs;
        Class<ShuffleClient> clazz = ShuffleClient.class;
        synchronized (ShuffleClient.class) {
            if (null != hdfsFs) return hdfsFs;
            try {
                hdfsFs = CelebornHadoopUtils.getHadoopFS(conf);
            }
            catch (Exception e) {
                logger.error("Celeborn initialize HDFS failed.", (Throwable)e);
            }
            return hdfsFs;
        }
    }

    public abstract void setupLifecycleManagerRef(String var1, int var2);

    public abstract void setupLifecycleManagerRef(RpcEndpointRef var1);

    public abstract int pushData(int var1, int var2, int var3, int var4, byte[] var5, int var6, int var7, int var8, int var9) throws IOException;

    public abstract void prepareForMergeData(int var1, int var2, int var3) throws IOException;

    public abstract int mergeData(int var1, int var2, int var3, int var4, byte[] var5, int var6, int var7, int var8, int var9) throws IOException;

    public abstract void pushMergedData(int var1, int var2, int var3) throws IOException;

    public abstract void mapperEnd(int var1, int var2, int var3, int var4) throws IOException;

    public abstract void mapPartitionMapperEnd(int var1, int var2, int var3, int var4, int var5) throws IOException;

    public abstract void cleanup(int var1, int var2, int var3);

    public abstract CelebornInputStream readPartition(int var1, int var2, int var3, int var4, int var5) throws IOException;

    public abstract CelebornInputStream readPartition(int var1, int var2, int var3) throws IOException;

    public abstract boolean unregisterShuffle(int var1, boolean var2);

    public abstract void shutdown();

    public abstract PartitionLocation registerMapPartitionTask(int var1, int var2, int var3, int var4, int var5) throws IOException;

    public abstract ConcurrentHashMap<Integer, PartitionLocation> getPartitionLocation(int var1, int var2, int var3);

    public abstract PushState getPushState(String var1);

    static {
        initialized = false;
        logger = LoggerFactory.getLogger(ShuffleClient.class);
    }
}

