/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block.policy;

import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.block.policy.BlockLocationPolicy;
import alluxio.client.block.policy.LocalFirstPolicy;
import alluxio.client.block.policy.options.GetWorkerOptions;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.com.google.common.base.Objects;
import alluxio.shaded.client.com.google.common.collect.Lists;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.wire.TieredIdentity;
import alluxio.wire.WorkerNetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@ThreadSafe
public final class LocalFirstAvoidEvictionPolicy
implements BlockLocationPolicy {
    private final LocalFirstPolicy mPolicy;
    private final long mBlockCapacityReserved;

    public LocalFirstAvoidEvictionPolicy(AlluxioConfiguration conf) {
        this(conf.getBytes(PropertyKey.USER_BLOCK_AVOID_EVICTION_POLICY_RESERVED_BYTES), conf);
    }

    LocalFirstAvoidEvictionPolicy(long blockCapacityReserved, AlluxioConfiguration conf) {
        this.mPolicy = LocalFirstPolicy.create(conf);
        this.mBlockCapacityReserved = blockCapacityReserved;
    }

    @VisibleForTesting
    LocalFirstAvoidEvictionPolicy(long blockCapacityReserved, TieredIdentity identity, AlluxioConfiguration conf) {
        this.mPolicy = new LocalFirstPolicy(identity, conf);
        this.mBlockCapacityReserved = blockCapacityReserved;
    }

    @Override
    public WorkerNetAddress getWorker(GetWorkerOptions options) {
        ArrayList<BlockWorkerInfo> allWorkers = Lists.newArrayList(options.getBlockWorkerInfos());
        List<BlockWorkerInfo> workers = allWorkers.stream().filter(worker -> this.getAvailableBytes((BlockWorkerInfo)worker) >= options.getBlockInfo().getLength()).collect(Collectors.toList());
        if (workers.isEmpty()) {
            workers = allWorkers;
        }
        GetWorkerOptions filteredWorkers = GetWorkerOptions.defaults().setBlockInfo(options.getBlockInfo()).setBlockWorkerInfos(workers);
        return this.mPolicy.getWorker(filteredWorkers);
    }

    private long getAvailableBytes(BlockWorkerInfo workerInfo) {
        long mCapacityBytes = workerInfo.getCapacityBytes();
        long mUsedBytes = workerInfo.getUsedBytes();
        return mCapacityBytes - mUsedBytes - this.mBlockCapacityReserved;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocalFirstAvoidEvictionPolicy)) {
            return false;
        }
        LocalFirstAvoidEvictionPolicy that = (LocalFirstAvoidEvictionPolicy)o;
        return Objects.equal(this.mPolicy, that.mPolicy) && Objects.equal(this.mBlockCapacityReserved, that.mBlockCapacityReserved);
    }

    public int hashCode() {
        return Objects.hashCode(this.mPolicy);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("policy", this.mPolicy).add("blockCapacityReservered", this.mBlockCapacityReserved).toString();
    }
}

