/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block.policy;

import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.block.policy.BlockLocationPolicy;
import alluxio.client.block.policy.options.GetWorkerOptions;
import alluxio.conf.AlluxioConfiguration;
import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.wire.WorkerNetAddress;

@ThreadSafe
public final class MostAvailableFirstPolicy
implements BlockLocationPolicy {
    public MostAvailableFirstPolicy(AlluxioConfiguration conf) {
    }

    @Override
    public WorkerNetAddress getWorker(GetWorkerOptions options) {
        long mostAvailableBytes = -1L;
        WorkerNetAddress result = null;
        for (BlockWorkerInfo workerInfo : options.getBlockWorkerInfos()) {
            if (workerInfo.getCapacityBytes() - workerInfo.getUsedBytes() <= mostAvailableBytes) continue;
            mostAvailableBytes = workerInfo.getCapacityBytes() - workerInfo.getUsedBytes();
            result = workerInfo.getNetAddress();
        }
        return result;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof MostAvailableFirstPolicy;
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).toString();
    }
}

