/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.client.file.ConfigHashSync;
import alluxio.client.file.FileSystemContext;
import alluxio.concurrent.CountingLatch;
import alluxio.conf.PropertyKey;
import alluxio.util.ThreadFactoryUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileSystemContextReinitializer
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemContextReinitializer.class);
    private final FileSystemContext mContext;
    private final ConfigHashSync mExecutor;
    private Future mFuture;
    private CountingLatch mLatch = new CountingLatch();
    private static final int REINIT_EXECUTOR_THREADPOOL_SIZE = 1;
    private static final ScheduledExecutorService REINIT_EXECUTOR = new ScheduledThreadPoolExecutor(1, ThreadFactoryUtils.build("config-hash-master-heartbeat-%d", true));

    public FileSystemContextReinitializer(FileSystemContext context) {
        this.mContext = context;
        this.mExecutor = new ConfigHashSync(context);
        this.mFuture = REINIT_EXECUTOR.scheduleAtFixedRate(() -> {
            try {
                this.mExecutor.heartbeat();
            }
            catch (Exception e) {
                LOG.error("Uncaught exception in config hearbeat executor, shutting down", (Throwable)e);
            }
        }, 0L, this.mContext.getClientContext().getClusterConf().getMs(PropertyKey.USER_CONF_SYNC_INTERVAL), TimeUnit.MILLISECONDS);
    }

    public void onSuccess() {
        this.mExecutor.resetMetaMasterConfigClient(this.mContext.getMasterClientContext());
    }

    public ReinitBlockerResource block() throws IOException, InterruptedException {
        Optional<IOException> exception = this.mExecutor.getException();
        if (exception.isPresent()) {
            throw exception.get();
        }
        ReinitBlockerResource r = new ReinitBlockerResource(this.mLatch);
        exception = this.mExecutor.getException();
        if (exception.isPresent()) {
            r.close();
            throw exception.get();
        }
        return r;
    }

    public ReinitAllowerResource allow() {
        return new ReinitAllowerResource(this.mLatch);
    }

    @Override
    public void close() {
        if (this.mFuture != null) {
            this.mFuture.cancel(true);
            this.mFuture = null;
            this.mExecutor.close();
        }
    }

    public static final class ReinitAllowerResource
    implements Closeable {
        private CountingLatch mLatch;

        public ReinitAllowerResource(CountingLatch latch) {
            this.mLatch = latch;
            this.mLatch.await();
        }

        @Override
        public void close() {
            this.mLatch.release();
        }
    }

    public static final class ReinitBlockerResource
    implements Closeable {
        private CountingLatch mLatch;

        public ReinitBlockerResource(CountingLatch latch) throws InterruptedException {
            this.mLatch = latch;
            this.mLatch.inc();
        }

        @Override
        public void close() {
            this.mLatch.dec();
        }
    }
}

