/*
 * Decompiled with CFR 0.152.
 */
package alluxio.resource;

import alluxio.resource.AlluxioResourceLeakDetectorFactory;
import alluxio.shaded.client.io.netty.util.ResourceLeakDetector;
import alluxio.shaded.client.io.netty.util.ResourceLeakTracker;
import alluxio.shaded.client.javax.annotation.Nullable;
import java.io.Closeable;

public abstract class CloseableResource<T>
implements Closeable {
    private static final ResourceLeakDetector<CloseableResource> DETECTOR = AlluxioResourceLeakDetectorFactory.instance().newResourceLeakDetector(CloseableResource.class);
    private final T mResource;
    @Nullable
    private final ResourceLeakTracker<CloseableResource> mTracker = DETECTOR.track(this);

    public CloseableResource(T resource) {
        this.mResource = resource;
    }

    public T get() {
        return this.mResource;
    }

    @Override
    public void close() {
        if (this.mTracker != null) {
            this.mTracker.close(this);
        }
        this.closeResource();
    }

    public abstract void closeResource();
}

