/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.user;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.UnauthenticatedException;
import alluxio.security.User;
import alluxio.security.authentication.AuthType;
import alluxio.security.user.BaseUserState;
import alluxio.security.user.UserState;
import alluxio.security.user.UserStateFactory;
import javax.security.auth.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoopUserState
extends BaseUserState {
    private static final Logger LOG = LoggerFactory.getLogger(NoopUserState.class);
    private static final User NOOP_USER = new User("");

    private NoopUserState(Subject subject, AlluxioConfiguration conf) {
        super(subject, conf);
    }

    @Override
    public User login() throws UnauthenticatedException {
        return NOOP_USER;
    }

    public static class Factory
    implements UserStateFactory {
        @Override
        public UserState create(Subject subject, AlluxioConfiguration conf, boolean isServer) {
            AuthType authType = conf.getEnum(PropertyKey.SECURITY_AUTHENTICATION_TYPE, AuthType.class);
            if (authType == AuthType.NOSASL) {
                return new NoopUserState(subject, conf);
            }
            return null;
        }
    }
}

